/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.bouncycastle.jcajce.provider.asymmetric.dsa;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import org.apache.pulsar.shade.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.apache.pulsar.shade.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.apache.pulsar.shade.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.apache.pulsar.shade.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.apache.pulsar.shade.org.bouncycastle.crypto.params.DSAParameters;
import org.apache.pulsar.shade.org.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import org.apache.pulsar.shade.org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import org.apache.pulsar.shade.org.bouncycastle.crypto.util.OpenSSHPrivateKeyUtil;
import org.apache.pulsar.shade.org.bouncycastle.crypto.util.OpenSSHPublicKeyUtil;
import org.apache.pulsar.shade.org.bouncycastle.jcajce.provider.asymmetric.dsa.BCDSAPrivateKey;
import org.apache.pulsar.shade.org.bouncycastle.jcajce.provider.asymmetric.dsa.BCDSAPublicKey;
import org.apache.pulsar.shade.org.bouncycastle.jcajce.provider.asymmetric.dsa.DSAUtil;
import org.apache.pulsar.shade.org.bouncycastle.jcajce.provider.asymmetric.util.BaseKeyFactorySpi;
import org.apache.pulsar.shade.org.bouncycastle.jcajce.spec.OpenSSHPrivateKeySpec;
import org.apache.pulsar.shade.org.bouncycastle.jcajce.spec.OpenSSHPublicKeySpec;

public class KeyFactorySpi
extends BaseKeyFactorySpi {
    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        if (clazz.isAssignableFrom(DSAPublicKeySpec.class) && key instanceof DSAPublicKey) {
            DSAPublicKey dSAPublicKey = (DSAPublicKey)key;
            return new DSAPublicKeySpec(dSAPublicKey.getY(), dSAPublicKey.getParams().getP(), dSAPublicKey.getParams().getQ(), dSAPublicKey.getParams().getG());
        }
        if (clazz.isAssignableFrom(DSAPrivateKeySpec.class) && key instanceof DSAPrivateKey) {
            DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)key;
            return new DSAPrivateKeySpec(dSAPrivateKey.getX(), dSAPrivateKey.getParams().getP(), dSAPrivateKey.getParams().getQ(), dSAPrivateKey.getParams().getG());
        }
        if (clazz.isAssignableFrom(OpenSSHPublicKeySpec.class) && key instanceof DSAPublicKey) {
            DSAPublicKey dSAPublicKey = (DSAPublicKey)key;
            try {
                return new OpenSSHPublicKeySpec(OpenSSHPublicKeyUtil.encodePublicKey(new DSAPublicKeyParameters(dSAPublicKey.getY(), new DSAParameters(dSAPublicKey.getParams().getP(), dSAPublicKey.getParams().getQ(), dSAPublicKey.getParams().getG()))));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("unable to produce encoding: " + iOException.getMessage());
            }
        }
        if (clazz.isAssignableFrom(OpenSSHPrivateKeySpec.class) && key instanceof DSAPrivateKey) {
            DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)key;
            try {
                return new OpenSSHPrivateKeySpec(OpenSSHPrivateKeyUtil.encodePrivateKey(new DSAPrivateKeyParameters(dSAPrivateKey.getX(), new DSAParameters(dSAPrivateKey.getParams().getP(), dSAPrivateKey.getParams().getQ(), dSAPrivateKey.getParams().getG()))));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("unable to produce encoding: " + iOException.getMessage());
            }
        }
        return super.engineGetKeySpec(key, clazz);
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key instanceof DSAPublicKey) {
            return new BCDSAPublicKey((DSAPublicKey)key);
        }
        if (key instanceof DSAPrivateKey) {
            return new BCDSAPrivateKey((DSAPrivateKey)key);
        }
        throw new InvalidKeyException("key type unknown");
    }

    public PrivateKey generatePrivate(PrivateKeyInfo privateKeyInfo) throws IOException {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm();
        if (DSAUtil.isDsaOid(aSN1ObjectIdentifier)) {
            return new BCDSAPrivateKey(privateKeyInfo);
        }
        throw new IOException("algorithm identifier " + aSN1ObjectIdentifier + " in key not recognised");
    }

    public PublicKey generatePublic(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = subjectPublicKeyInfo.getAlgorithm().getAlgorithm();
        if (DSAUtil.isDsaOid(aSN1ObjectIdentifier)) {
            return new BCDSAPublicKey(subjectPublicKeyInfo);
        }
        throw new IOException("algorithm identifier " + aSN1ObjectIdentifier + " in key not recognised");
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof DSAPrivateKeySpec) {
            return new BCDSAPrivateKey((DSAPrivateKeySpec)keySpec);
        }
        if (keySpec instanceof OpenSSHPrivateKeySpec) {
            AsymmetricKeyParameter asymmetricKeyParameter = OpenSSHPrivateKeyUtil.parsePrivateKeyBlob(((OpenSSHPrivateKeySpec)keySpec).getEncoded());
            if (asymmetricKeyParameter instanceof DSAPrivateKeyParameters) {
                return this.engineGeneratePrivate(new DSAPrivateKeySpec(((DSAPrivateKeyParameters)asymmetricKeyParameter).getX(), ((DSAPrivateKeyParameters)asymmetricKeyParameter).getParameters().getP(), ((DSAPrivateKeyParameters)asymmetricKeyParameter).getParameters().getQ(), ((DSAPrivateKeyParameters)asymmetricKeyParameter).getParameters().getG()));
            }
            throw new IllegalArgumentException("openssh private key is not dsa privare key");
        }
        return super.engineGeneratePrivate(keySpec);
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof DSAPublicKeySpec) {
            try {
                return new BCDSAPublicKey((DSAPublicKeySpec)keySpec);
            }
            catch (Exception exception) {
                throw new InvalidKeySpecException("invalid KeySpec: " + exception.getMessage()){

                    public Throwable getCause() {
                        return exception;
                    }
                };
            }
        }
        if (keySpec instanceof OpenSSHPublicKeySpec) {
            AsymmetricKeyParameter asymmetricKeyParameter = OpenSSHPublicKeyUtil.parsePublicKey(((OpenSSHPublicKeySpec)keySpec).getEncoded());
            if (asymmetricKeyParameter instanceof DSAPublicKeyParameters) {
                return this.engineGeneratePublic(new DSAPublicKeySpec(((DSAPublicKeyParameters)asymmetricKeyParameter).getY(), ((DSAPublicKeyParameters)asymmetricKeyParameter).getParameters().getP(), ((DSAPublicKeyParameters)asymmetricKeyParameter).getParameters().getQ(), ((DSAPublicKeyParameters)asymmetricKeyParameter).getParameters().getG()));
            }
            throw new IllegalArgumentException("openssh public key is not dsa public key");
        }
        return super.engineGeneratePublic(keySpec);
    }
}

