/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.bouncycastle.asn1.cms;

import java.math.BigInteger;
import org.apache.pulsar.shade.org.bouncycastle.asn1.ASN1EncodableVector;
import org.apache.pulsar.shade.org.bouncycastle.asn1.ASN1Integer;
import org.apache.pulsar.shade.org.bouncycastle.asn1.ASN1Object;
import org.apache.pulsar.shade.org.bouncycastle.asn1.ASN1Primitive;
import org.apache.pulsar.shade.org.bouncycastle.asn1.ASN1Sequence;
import org.apache.pulsar.shade.org.bouncycastle.asn1.DERSequence;
import org.apache.pulsar.shade.org.bouncycastle.asn1.x500.X500Name;
import org.apache.pulsar.shade.org.bouncycastle.asn1.x509.Certificate;
import org.apache.pulsar.shade.org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.apache.pulsar.shade.org.bouncycastle.asn1.x509.X509Name;

public class IssuerAndSerialNumber
extends ASN1Object {
    private X500Name name;
    private ASN1Integer serialNumber;

    public static IssuerAndSerialNumber getInstance(Object object) {
        if (object instanceof IssuerAndSerialNumber) {
            return (IssuerAndSerialNumber)object;
        }
        if (object != null) {
            return new IssuerAndSerialNumber(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public IssuerAndSerialNumber(ASN1Sequence aSN1Sequence) {
        this.name = X500Name.getInstance(aSN1Sequence.getObjectAt(0));
        this.serialNumber = (ASN1Integer)aSN1Sequence.getObjectAt(1);
    }

    public IssuerAndSerialNumber(Certificate certificate) {
        this.name = certificate.getIssuer();
        this.serialNumber = certificate.getSerialNumber();
    }

    public IssuerAndSerialNumber(X509CertificateStructure x509CertificateStructure) {
        this.name = x509CertificateStructure.getIssuer();
        this.serialNumber = x509CertificateStructure.getSerialNumber();
    }

    public IssuerAndSerialNumber(X500Name x500Name, BigInteger bigInteger) {
        this.name = x500Name;
        this.serialNumber = new ASN1Integer(bigInteger);
    }

    public IssuerAndSerialNumber(X509Name x509Name, BigInteger bigInteger) {
        this.name = X500Name.getInstance(x509Name);
        this.serialNumber = new ASN1Integer(bigInteger);
    }

    public IssuerAndSerialNumber(X509Name x509Name, ASN1Integer aSN1Integer) {
        this.name = X500Name.getInstance(x509Name);
        this.serialNumber = aSN1Integer;
    }

    public X500Name getName() {
        return this.name;
    }

    public ASN1Integer getSerialNumber() {
        return this.serialNumber;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(2);
        aSN1EncodableVector.add(this.name);
        aSN1EncodableVector.add(this.serialNumber);
        return new DERSequence(aSN1EncodableVector);
    }
}

