/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.enumerator.subscriber;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.pulsar.source.enumerator.subscriber.impl.TopicListSubscriber;
import org.apache.flink.connector.pulsar.source.enumerator.subscriber.impl.TopicPatternSubscriber;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicPartition;
import org.apache.flink.connector.pulsar.source.enumerator.topic.range.RangeGenerator;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.RegexSubscriptionMode;

@Internal
public interface PulsarSubscriber
extends Serializable {
    public Set<TopicPartition> getSubscribedTopicPartitions(RangeGenerator var1, int var2) throws Exception;

    public void open(PulsarClient var1, PulsarAdmin var2);

    public static PulsarSubscriber getTopicListSubscriber(List<String> topics) {
        return new TopicListSubscriber(topics);
    }

    public static PulsarSubscriber getTopicPatternSubscriber(Pattern topicPattern, RegexSubscriptionMode subscriptionMode) {
        return new TopicPatternSubscriber(topicPattern, subscriptionMode);
    }
}

