/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source;

import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.connector.source.SourceReader;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.api.connector.source.SplitEnumerator;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.connector.pulsar.common.crypto.PulsarCrypto;
import org.apache.flink.connector.pulsar.source.PulsarSourceBuilder;
import org.apache.flink.connector.pulsar.source.config.SourceConfiguration;
import org.apache.flink.connector.pulsar.source.enumerator.PulsarSourceEnumState;
import org.apache.flink.connector.pulsar.source.enumerator.PulsarSourceEnumStateSerializer;
import org.apache.flink.connector.pulsar.source.enumerator.PulsarSourceEnumerator;
import org.apache.flink.connector.pulsar.source.enumerator.cursor.StartCursor;
import org.apache.flink.connector.pulsar.source.enumerator.cursor.StopCursor;
import org.apache.flink.connector.pulsar.source.enumerator.subscriber.PulsarSubscriber;
import org.apache.flink.connector.pulsar.source.enumerator.topic.range.RangeGenerator;
import org.apache.flink.connector.pulsar.source.reader.PulsarSourceReader;
import org.apache.flink.connector.pulsar.source.reader.deserializer.PulsarDeserializationSchema;
import org.apache.flink.connector.pulsar.source.split.PulsarPartitionSplit;
import org.apache.flink.connector.pulsar.source.split.PulsarPartitionSplitSerializer;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.pulsar.client.api.PulsarClientException;

@PublicEvolving
public final class PulsarSource<OUT>
implements Source<OUT, PulsarPartitionSplit, PulsarSourceEnumState>,
ResultTypeQueryable<OUT> {
    private static final long serialVersionUID = 7773108631275567433L;
    private final SourceConfiguration sourceConfiguration;
    private final PulsarSubscriber subscriber;
    private final RangeGenerator rangeGenerator;
    private final StartCursor startCursor;
    private final StopCursor stopCursor;
    private final Boundedness boundedness;
    private final PulsarDeserializationSchema<OUT> deserializationSchema;
    private final PulsarCrypto pulsarCrypto;

    PulsarSource(SourceConfiguration sourceConfiguration, PulsarSubscriber subscriber, RangeGenerator rangeGenerator, StartCursor startCursor, StopCursor stopCursor, Boundedness boundedness, PulsarDeserializationSchema<OUT> deserializationSchema, PulsarCrypto pulsarCrypto) {
        this.sourceConfiguration = sourceConfiguration;
        this.subscriber = subscriber;
        this.rangeGenerator = rangeGenerator;
        this.startCursor = startCursor;
        this.stopCursor = stopCursor;
        this.boundedness = boundedness;
        this.deserializationSchema = deserializationSchema;
        this.pulsarCrypto = pulsarCrypto;
    }

    public static <OUT> PulsarSourceBuilder<OUT> builder() {
        return new PulsarSourceBuilder();
    }

    public Boundedness getBoundedness() {
        return this.boundedness;
    }

    @Internal
    public SourceReader<OUT, PulsarPartitionSplit> createReader(SourceReaderContext readerContext) throws Exception {
        return PulsarSourceReader.create(this.sourceConfiguration, this.deserializationSchema, this.pulsarCrypto, readerContext);
    }

    @Internal
    public SplitEnumerator<PulsarPartitionSplit, PulsarSourceEnumState> createEnumerator(SplitEnumeratorContext<PulsarPartitionSplit> enumContext) throws PulsarClientException {
        return new PulsarSourceEnumerator(this.subscriber, this.startCursor, this.stopCursor, this.rangeGenerator, this.sourceConfiguration, enumContext);
    }

    @Internal
    public SplitEnumerator<PulsarPartitionSplit, PulsarSourceEnumState> restoreEnumerator(SplitEnumeratorContext<PulsarPartitionSplit> enumContext, PulsarSourceEnumState checkpoint) throws PulsarClientException {
        return new PulsarSourceEnumerator(this.subscriber, this.startCursor, this.stopCursor, this.rangeGenerator, this.sourceConfiguration, enumContext, checkpoint);
    }

    @Internal
    public SimpleVersionedSerializer<PulsarPartitionSplit> getSplitSerializer() {
        return PulsarPartitionSplitSerializer.INSTANCE;
    }

    @Internal
    public SimpleVersionedSerializer<PulsarSourceEnumState> getEnumeratorCheckpointSerializer() {
        return PulsarSourceEnumStateSerializer.INSTANCE;
    }

    public TypeInformation<OUT> getProducedType() {
        return this.deserializationSchema.getProducedType();
    }
}

