/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.common.config;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.shade.com.google.common.collect.ImmutableList;
import org.apache.pulsar.shade.com.google.common.collect.ImmutableSet;

@Internal
public class PulsarConfigValidator {
    private final List<Set<ConfigOption<?>>> conflictOptions;
    private final Set<ConfigOption<?>> requiredOptions;

    private PulsarConfigValidator(List<Set<ConfigOption<?>>> conflictOptions, Set<ConfigOption<?>> requiredOptions) {
        this.conflictOptions = conflictOptions;
        this.requiredOptions = requiredOptions;
    }

    void validate(Configuration configuration) {
        this.requiredOptions.forEach(option -> Preconditions.checkArgument((boolean)configuration.contains(option), (String)"Config option %s is not provided for pulsar client.", (Object[])new Object[]{option}));
        this.conflictOptions.forEach(options -> {
            long nums = options.stream().filter(arg_0 -> ((Configuration)configuration).contains(arg_0)).count();
            Preconditions.checkArgument((nums <= 1L ? 1 : 0) != 0, (String)"Conflict config options %s were provided, we only support one of them for creating pulsar client.", (Object[])new Object[]{options});
        });
    }

    public static PulsarConfigValidatorBuilder builder() {
        return new PulsarConfigValidatorBuilder();
    }

    public static class PulsarConfigValidatorBuilder {
        private final List<Set<ConfigOption<?>>> conflictOptions = new ArrayList();
        private final Set<ConfigOption<?>> requiredOptions = new HashSet();

        public PulsarConfigValidatorBuilder conflictOptions(ConfigOption<?> ... options) {
            Preconditions.checkArgument((options.length > 1 ? 1 : 0) != 0, (Object)"You should provide at least two conflict options.");
            this.conflictOptions.add(ImmutableSet.copyOf(options));
            return this;
        }

        public PulsarConfigValidatorBuilder requiredOption(ConfigOption<?> option) {
            this.requiredOptions.add(option);
            return this;
        }

        public PulsarConfigValidator build() {
            ImmutableList<Set<ConfigOption<?>>> conflict = ImmutableList.copyOf(this.conflictOptions);
            ImmutableSet<ConfigOption<?>> required = ImmutableSet.copyOf(this.requiredOptions);
            return new PulsarConfigValidator(conflict, required);
        }
    }
}

