/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.serde.json;

import io.debezium.common.annotation.Incubating;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import java.util.Map;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.config.AbstractConfig;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.config.ConfigDef;

@Incubating
public class JsonSerdeConfig
extends AbstractConfig {
    public static final Field FROM_FIELD = Field.create("from.field").withDisplayName("What Envelope field should be deserialized (before/after)").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Enables user to choose which of Envelope provided fields should be deserialized as the payload.If not set then the envelope is provided as is.").withValidation(JsonSerdeConfig::isEnvelopeFieldName);
    public static final Field UNKNOWN_PROPERTIES_IGNORED = Field.create("unknown.properties.ignored").withDisplayName("Unknown properties ignored").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("Controls whether unknown properties will be ignored or cause a JsonMappingException when encountered.").withDefault(false);
    private static final ConfigDef CONFIG = new ConfigDef();
    private String sourceField = this.getString(FROM_FIELD.name());
    private boolean unknownPropertiesIgnored = this.getBoolean(UNKNOWN_PROPERTIES_IGNORED.name());

    private static int isEnvelopeFieldName(Configuration config, Field field, Field.ValidationOutput problems) {
        String fieldName = config.getString(field);
        if (fieldName == null) {
            return 0;
        }
        if (!"after".equals(fieldName) && !"before".equals(fieldName)) {
            problems.accept(field, fieldName, "Allowed values are 'before' or 'after'");
            return 1;
        }
        return 0;
    }

    public static ConfigDef configDef() {
        return CONFIG;
    }

    public JsonSerdeConfig(Map<String, ?> props) {
        super(CONFIG, props);
    }

    public String sourceField() {
        return this.sourceField;
    }

    public boolean asEnvelope() {
        return this.sourceField == null;
    }

    public boolean isUnknownPropertiesIgnored() {
        return this.unknownPropertiesIgnored;
    }

    static {
        Field.group(CONFIG, "Source", FROM_FIELD, UNKNOWN_PROPERTIES_IGNORED);
    }
}

