/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.postgres.source.config;

import io.debezium.config.Configuration;
import io.debezium.connector.postgresql.PostgresConnector;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.flink.cdc.connectors.base.config.JdbcSourceConfigFactory;
import org.apache.flink.cdc.connectors.base.source.EmbeddedFlinkDatabaseHistory;
import org.apache.flink.cdc.connectors.base.utils.EnvironmentUtils;
import org.apache.flink.cdc.connectors.postgres.source.config.PostgresSourceConfig;
import org.apache.flink.cdc.connectors.postgres.source.config.PostgresSourceOptions;
import org.apache.flink.util.Preconditions;

public class PostgresSourceConfigFactory
extends JdbcSourceConfigFactory {
    private static final long serialVersionUID = 1L;
    private Duration heartbeatInterval = (Duration)PostgresSourceOptions.HEARTBEAT_INTERVAL.defaultValue();
    private static final String JDBC_DRIVER = "org.postgresql.Driver";
    private String pluginName = "decoderbufs";
    private String slotName = "flink";
    private String database;
    private List<String> schemaList;

    @Override
    public PostgresSourceConfig create(int subtaskId) {
        EnvironmentUtils.checkSupportCheckpointsAfterTasksFinished(this.closeIdleReaders);
        Properties props = new Properties();
        props.setProperty("connector.class", PostgresConnector.class.getCanonicalName());
        props.setProperty("plugin.name", this.pluginName);
        props.setProperty("database.server.name", "postgres_cdc_source");
        props.setProperty("database.hostname", (String)Preconditions.checkNotNull((Object)this.hostname));
        props.setProperty("database.dbname", (String)Preconditions.checkNotNull((Object)this.database));
        props.setProperty("database.user", (String)Preconditions.checkNotNull((Object)this.username));
        props.setProperty("database.password", (String)Preconditions.checkNotNull((Object)this.password));
        props.setProperty("database.port", String.valueOf(this.port));
        props.setProperty("slot.name", (String)Preconditions.checkNotNull((Object)this.slotName));
        props.setProperty("database.history", EmbeddedFlinkDatabaseHistory.class.getCanonicalName());
        props.setProperty("database.history.instance.name", UUID.randomUUID() + "_" + subtaskId);
        props.setProperty("database.history.skip.unparseable.ddl", String.valueOf(true));
        props.setProperty("database.history.refer.ddl", String.valueOf(true));
        props.setProperty("database.tcpKeepAlive", String.valueOf(true));
        props.setProperty("heartbeat.interval.ms", String.valueOf(this.heartbeatInterval.toMillis()));
        props.setProperty("include.schema.changes", String.valueOf(this.includeSchemaChanges));
        if (this.schemaList != null) {
            props.setProperty("schema.include.list", String.join((CharSequence)",", this.schemaList));
        }
        if (this.tableList != null) {
            props.setProperty("table.include.list", String.join((CharSequence)",", this.tableList));
        }
        if (this.dbzProperties != null) {
            props.putAll((Map<?, ?>)this.dbzProperties);
        }
        props.put("snapshot.mode", "never");
        Configuration dbzConfiguration = Configuration.from(props);
        return new PostgresSourceConfig(subtaskId, this.startupOptions, Collections.singletonList(this.database), this.schemaList, this.tableList, this.splitSize, this.splitMetaGroupSize, this.distributionFactorUpper, this.distributionFactorLower, this.includeSchemaChanges, this.closeIdleReaders, props, dbzConfiguration, JDBC_DRIVER, this.hostname, this.port, this.username, this.password, this.fetchSize, this.serverTimeZone, this.connectTimeout, this.connectMaxRetries, this.connectionPoolSize, this.chunkKeyColumn, this.skipSnapshotBackfill, this.scanNewlyAddedTableEnabled);
    }

    public void schemaList(String[] schemaList) {
        this.schemaList = Arrays.asList(schemaList);
    }

    public void decodingPluginName(String name) {
        this.pluginName = name;
    }

    public void database(String database) {
        this.database = database;
    }

    public void slotName(String slotName) {
        this.slotName = slotName;
    }

    public void heartbeatInterval(Duration heartbeatInterval) {
        this.heartbeatInterval = heartbeatInterval;
    }
}

