/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import com.github.shyiko.mysql.binlog.GtidSet;
import io.debezium.connector.mysql.GtidSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class GtidUtils {
    public static GtidSet fixRestoredGtidSet(GtidSet serverGtidSet, GtidSet restoredGtidSet) {
        HashMap<String, GtidSet.UUIDSet> newSet = new HashMap<String, GtidSet.UUIDSet>();
        serverGtidSet.getUUIDSets().forEach(uuidSet -> newSet.put(uuidSet.getUUID(), (GtidSet.UUIDSet)uuidSet));
        for (GtidSet.UUIDSet restoredUuidSet : restoredGtidSet.getUUIDSets()) {
            GtidSet.UUIDSet serverUuidSet = (GtidSet.UUIDSet)newSet.get(restoredUuidSet.getUUID());
            if (serverUuidSet != null) {
                List<GtidSet.Interval> serverIntervals = serverUuidSet.getIntervals();
                List<GtidSet.Interval> restoredIntervals = restoredUuidSet.getIntervals();
                long earliestRestoredTx = GtidUtils.getMinIntervalStart(restoredIntervals);
                ArrayList<GtidSet.Interval> merged = new ArrayList<GtidSet.Interval>();
                for (GtidSet.Interval serverInterval : serverIntervals) {
                    if (serverInterval.getStart() < earliestRestoredTx) {
                        long end = Math.min(serverInterval.getEnd(), earliestRestoredTx - 1L);
                        merged.add(new GtidSet.Interval(serverInterval.getStart(), end));
                    }
                    for (GtidSet.Interval restoredInterval : restoredIntervals) {
                        long intersectionEnd;
                        long intersectionStart;
                        if (serverInterval.getStart() > restoredInterval.getEnd() || serverInterval.getEnd() < restoredInterval.getStart() || (intersectionStart = Math.max(serverInterval.getStart(), restoredInterval.getStart())) > (intersectionEnd = Math.min(serverInterval.getEnd(), restoredInterval.getEnd()))) continue;
                        merged.add(new GtidSet.Interval(intersectionStart, intersectionEnd));
                    }
                }
                GtidSet.UUIDSet mergedUuidSet = new GtidSet.UUIDSet(new GtidSet.UUIDSet(restoredUuidSet.getUUID(), merged));
                newSet.put(restoredUuidSet.getUUID(), mergedUuidSet);
                continue;
            }
            newSet.put(restoredUuidSet.getUUID(), restoredUuidSet);
        }
        return new GtidSet(newSet);
    }

    private static long getMinIntervalStart(List<GtidSet.Interval> intervals) {
        return Collections.min(intervals, Comparator.comparingLong(GtidSet.Interval::getStart)).getStart();
    }

    public static GtidSet mergeGtidSetInto(GtidSet base, GtidSet toMerge) {
        HashMap<String, GtidSet.UUIDSet> newSet = new HashMap<String, GtidSet.UUIDSet>();
        base.getUUIDSets().forEach(uuidSet -> newSet.put(uuidSet.getUUID(), (GtidSet.UUIDSet)uuidSet));
        for (GtidSet.UUIDSet uuidSet2 : toMerge.getUUIDSets()) {
            if (newSet.containsKey(uuidSet2.getUUID())) continue;
            newSet.put(uuidSet2.getUUID(), uuidSet2);
        }
        return new GtidSet(newSet);
    }
}

