/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.oceanbase.source.converter;

import java.time.ZoneId;
import java.util.Optional;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.Schema;
import org.apache.flink.cdc.debezium.table.DeserializationRuntimeConverter;
import org.apache.flink.cdc.debezium.table.DeserializationRuntimeConverterFactory;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.types.logical.LogicalType;

public class OceanBaseDeserializationConverterFactory {
    public static DeserializationRuntimeConverterFactory instance() {
        return new DeserializationRuntimeConverterFactory(){
            private static final long serialVersionUID = 1L;

            @Override
            public Optional<DeserializationRuntimeConverter> createUserDefinedConverter(LogicalType logicalType, ZoneId serverTimeZone) {
                switch (logicalType.getTypeRoot()) {
                    case ARRAY: {
                        return OceanBaseDeserializationConverterFactory.createArrayConverter();
                    }
                }
                return Optional.empty();
            }
        };
    }

    private static Optional<DeserializationRuntimeConverter> createArrayConverter() {
        return Optional.of(new DeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object dbzObj, Schema schema) throws Exception {
                if (dbzObj instanceof String) {
                    String[] enums = ((String)dbzObj).split(",");
                    Object[] elements = new StringData[enums.length];
                    for (int i = 0; i < enums.length; ++i) {
                        elements[i] = StringData.fromString((String)enums[i]);
                    }
                    return new GenericArrayData(elements);
                }
                throw new IllegalArgumentException(String.format("Unable convert to Flink ARRAY type from unexpected value '%s'", dbzObj));
            }
        });
    }
}

