/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.base.source;

import io.debezium.relational.TableId;
import java.util.List;
import java.util.function.Supplier;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.api.connector.source.SplitEnumerator;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.cdc.common.annotation.Experimental;
import org.apache.flink.cdc.common.annotation.VisibleForTesting;
import org.apache.flink.cdc.connectors.base.config.SourceConfig;
import org.apache.flink.cdc.connectors.base.dialect.DataSourceDialect;
import org.apache.flink.cdc.connectors.base.source.assigner.HybridSplitAssigner;
import org.apache.flink.cdc.connectors.base.source.assigner.SplitAssigner;
import org.apache.flink.cdc.connectors.base.source.assigner.StreamSplitAssigner;
import org.apache.flink.cdc.connectors.base.source.assigner.state.HybridPendingSplitsState;
import org.apache.flink.cdc.connectors.base.source.assigner.state.PendingSplitsState;
import org.apache.flink.cdc.connectors.base.source.assigner.state.PendingSplitsStateSerializer;
import org.apache.flink.cdc.connectors.base.source.assigner.state.StreamPendingSplitsState;
import org.apache.flink.cdc.connectors.base.source.enumerator.IncrementalSourceEnumerator;
import org.apache.flink.cdc.connectors.base.source.meta.offset.OffsetFactory;
import org.apache.flink.cdc.connectors.base.source.meta.split.SourceRecords;
import org.apache.flink.cdc.connectors.base.source.meta.split.SourceSplitBase;
import org.apache.flink.cdc.connectors.base.source.meta.split.SourceSplitSerializer;
import org.apache.flink.cdc.connectors.base.source.meta.split.SourceSplitState;
import org.apache.flink.cdc.connectors.base.source.metrics.SourceReaderMetrics;
import org.apache.flink.cdc.connectors.base.source.reader.IncrementalSourceReader;
import org.apache.flink.cdc.connectors.base.source.reader.IncrementalSourceReaderContext;
import org.apache.flink.cdc.connectors.base.source.reader.IncrementalSourceRecordEmitter;
import org.apache.flink.cdc.connectors.base.source.reader.IncrementalSourceSplitReader;
import org.apache.flink.cdc.connectors.base.source.utils.hooks.SnapshotPhaseHooks;
import org.apache.flink.cdc.debezium.DebeziumDeserializationSchema;
import org.apache.flink.connector.base.source.reader.RecordEmitter;
import org.apache.flink.connector.base.source.reader.RecordsWithSplitIds;
import org.apache.flink.connector.base.source.reader.synchronization.FutureCompletingBlockingQueue;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.util.FlinkRuntimeException;

@Experimental
public class IncrementalSource<T, C extends SourceConfig>
implements Source<T, SourceSplitBase, PendingSplitsState>,
ResultTypeQueryable<T> {
    private static final long serialVersionUID = 1L;
    protected final SourceConfig.Factory<C> configFactory;
    protected final DataSourceDialect<C> dataSourceDialect;
    protected final OffsetFactory offsetFactory;
    protected final DebeziumDeserializationSchema<T> deserializationSchema;
    protected final SourceSplitSerializer sourceSplitSerializer;
    protected SnapshotPhaseHooks snapshotHooks = SnapshotPhaseHooks.empty();

    public IncrementalSource(SourceConfig.Factory<C> configFactory, DebeziumDeserializationSchema<T> deserializationSchema, final OffsetFactory offsetFactory, DataSourceDialect<C> dataSourceDialect) {
        this.configFactory = configFactory;
        this.deserializationSchema = deserializationSchema;
        this.offsetFactory = offsetFactory;
        this.dataSourceDialect = dataSourceDialect;
        this.sourceSplitSerializer = new SourceSplitSerializer(){

            @Override
            public OffsetFactory getOffsetFactory() {
                return offsetFactory;
            }
        };
    }

    public Boundedness getBoundedness() {
        C sourceConfig = this.configFactory.create(0);
        if (sourceConfig.getStartupOptions().isSnapshotOnly()) {
            return Boundedness.BOUNDED;
        }
        return Boundedness.CONTINUOUS_UNBOUNDED;
    }

    public IncrementalSourceReader<T, C> createReader(SourceReaderContext readerContext) throws Exception {
        C sourceConfig = this.configFactory.create(readerContext.getIndexOfSubtask());
        FutureCompletingBlockingQueue elementsQueue = new FutureCompletingBlockingQueue();
        SourceReaderMetrics sourceReaderMetrics = new SourceReaderMetrics(readerContext.metricGroup());
        sourceReaderMetrics.registerMetrics();
        IncrementalSourceReaderContext incrementalSourceReaderContext = new IncrementalSourceReaderContext(readerContext);
        Supplier splitReaderSupplier = () -> new IncrementalSourceSplitReader<SourceConfig>(readerContext.getIndexOfSubtask(), (DataSourceDialect<SourceConfig>)this.dataSourceDialect, (SourceConfig)sourceConfig, incrementalSourceReaderContext, this.snapshotHooks);
        return new IncrementalSourceReader((FutureCompletingBlockingQueue<RecordsWithSplitIds<SourceRecords>>)elementsQueue, splitReaderSupplier, this.createRecordEmitter((SourceConfig)sourceConfig, sourceReaderMetrics), readerContext.getConfiguration(), incrementalSourceReaderContext, sourceConfig, this.sourceSplitSerializer, this.dataSourceDialect);
    }

    public SplitEnumerator<SourceSplitBase, PendingSplitsState> createEnumerator(SplitEnumeratorContext<SourceSplitBase> enumContext) {
        SplitAssigner splitAssigner;
        C sourceConfig = this.configFactory.create(0);
        if (!sourceConfig.getStartupOptions().isStreamOnly()) {
            try {
                List<TableId> remainingTables = this.dataSourceDialect.discoverDataCollections(sourceConfig);
                boolean isTableIdCaseSensitive = this.dataSourceDialect.isDataCollectionIdCaseSensitive(sourceConfig);
                splitAssigner = new HybridSplitAssigner<C>(sourceConfig, enumContext.currentParallelism(), remainingTables, isTableIdCaseSensitive, this.dataSourceDialect, this.offsetFactory);
            }
            catch (Exception e) {
                throw new FlinkRuntimeException("Failed to discover captured tables for enumerator", (Throwable)e);
            }
        } else {
            splitAssigner = new StreamSplitAssigner((SourceConfig)sourceConfig, this.dataSourceDialect, this.offsetFactory);
        }
        return new IncrementalSourceEnumerator(enumContext, (SourceConfig)sourceConfig, splitAssigner, this.getBoundedness());
    }

    public SplitEnumerator<SourceSplitBase, PendingSplitsState> restoreEnumerator(SplitEnumeratorContext<SourceSplitBase> enumContext, PendingSplitsState checkpoint) {
        SplitAssigner splitAssigner;
        C sourceConfig = this.configFactory.create(0);
        if (checkpoint instanceof HybridPendingSplitsState) {
            splitAssigner = new HybridSplitAssigner<C>(sourceConfig, enumContext.currentParallelism(), (HybridPendingSplitsState)checkpoint, this.dataSourceDialect, this.offsetFactory);
        } else if (checkpoint instanceof StreamPendingSplitsState) {
            splitAssigner = new StreamSplitAssigner((SourceConfig)sourceConfig, (StreamPendingSplitsState)checkpoint, (DataSourceDialect)this.dataSourceDialect, this.offsetFactory);
        } else {
            throw new UnsupportedOperationException("Unsupported restored PendingSplitsState: " + checkpoint);
        }
        return new IncrementalSourceEnumerator(enumContext, (SourceConfig)sourceConfig, splitAssigner, this.getBoundedness());
    }

    public SimpleVersionedSerializer<SourceSplitBase> getSplitSerializer() {
        return this.sourceSplitSerializer;
    }

    public SimpleVersionedSerializer<PendingSplitsState> getEnumeratorCheckpointSerializer() {
        SourceSplitSerializer sourceSplitSerializer = (SourceSplitSerializer)this.getSplitSerializer();
        return new PendingSplitsStateSerializer(sourceSplitSerializer);
    }

    public TypeInformation<T> getProducedType() {
        return this.deserializationSchema.getProducedType();
    }

    protected RecordEmitter<SourceRecords, T, SourceSplitState> createRecordEmitter(SourceConfig sourceConfig, SourceReaderMetrics sourceReaderMetrics) {
        return new IncrementalSourceRecordEmitter<T>(this.deserializationSchema, sourceReaderMetrics, sourceConfig.isIncludeSchemaChanges(), this.offsetFactory);
    }

    @VisibleForTesting
    public void setSnapshotHooks(SnapshotPhaseHooks snapshotHooks) {
        this.snapshotHooks = snapshotHooks;
    }
}

