/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.oms.logmessage.typehelper;

import com.oceanbase.oms.common.enums.DbTypeEnum;
import com.oceanbase.oms.logmessage.typehelper.DB2LogTypeHelper;
import com.oceanbase.oms.logmessage.typehelper.LogTypeHelper;
import com.oceanbase.oms.logmessage.typehelper.MySQLLogTypeHelper;
import com.oceanbase.oms.logmessage.typehelper.OBLogTypeHelper;
import com.oceanbase.oms.logmessage.typehelper.OracleLogTypeHelper;
import com.oceanbase.oms.logmessage.typehelper.XLogTypeHelper;

public abstract class LogTypeHelperFactory {
    public static LogTypeHelper getInstance(DbTypeEnum dbType) {
        switch (dbType) {
            case OB_MYSQL: 
            case OB_ORACLE: 
            case OB_05: {
                return OBLogTypeHelper.OB_LOG_TYPE_HELPER;
            }
            case MYSQL: {
                return MySQLLogTypeHelper.MYSQL_LOG_TYPE_HELPER;
            }
            case ORACLE: {
                return OracleLogTypeHelper.ORACLE_LOG_TYPE_HELPER;
            }
            case DB2_LUW: {
                return DB2LogTypeHelper.DB2_LOG_TYPE_HELPER;
            }
            case POSTGRESQL: {
                return XLogTypeHelper.XLOG_TYPE_HELPER;
            }
        }
        throw new IllegalArgumentException("Unsupported dbType " + (Object)((Object)dbType));
    }
}

