/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.common.data;

import java.time.LocalTime;
import java.util.Objects;

public class TimeData
implements Comparable<TimeData> {
    private static final int SECONDS_TO_MILLIS = 1000;
    private static final int MILLIS_TO_MICRO = 1000;
    private static final int MILLIS_TO_NANO = 1000000;
    private final int millisOfDay;

    private TimeData(int millisOfDay) {
        this.millisOfDay = millisOfDay;
    }

    public static TimeData fromSecondOfDay(int secondOfDay) {
        return new TimeData(secondOfDay * 1000);
    }

    public static TimeData fromMillisOfDay(int millisOfDay) {
        return new TimeData(millisOfDay);
    }

    public static TimeData fromMicroOfDay(long microOfDay) {
        return new TimeData((int)(microOfDay / 1000L));
    }

    public static TimeData fromNanoOfDay(long nanoOfDay) {
        return new TimeData((int)(nanoOfDay / 1000000L));
    }

    public static TimeData fromLocalTime(LocalTime localTime) {
        return TimeData.fromNanoOfDay(localTime.toNanoOfDay());
    }

    public static TimeData fromIsoLocalTimeString(String timeString) {
        return TimeData.fromLocalTime(LocalTime.parse(timeString));
    }

    public int toMillisOfDay() {
        return this.millisOfDay;
    }

    public LocalTime toLocalTime() {
        return LocalTime.ofNanoOfDay((long)this.millisOfDay * 1000000L);
    }

    public String toString() {
        return this.toLocalTime().toString();
    }

    public final boolean equals(Object o) {
        if (!(o instanceof TimeData)) {
            return false;
        }
        TimeData timeData = (TimeData)o;
        return this.millisOfDay == timeData.millisOfDay;
    }

    @Override
    public int compareTo(TimeData other) {
        return Long.compare(this.millisOfDay, other.millisOfDay);
    }

    public int hashCode() {
        return Objects.hash(this.millisOfDay);
    }
}

