/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.shaded.com.zaxxer.hikari.metrics.prometheus;

import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.cdc.connectors.shaded.com.zaxxer.hikari.metrics.IMetricsTracker;
import org.apache.flink.cdc.connectors.shaded.com.zaxxer.hikari.metrics.MetricsTrackerFactory;
import org.apache.flink.cdc.connectors.shaded.com.zaxxer.hikari.metrics.PoolStats;
import org.apache.flink.cdc.connectors.shaded.com.zaxxer.hikari.metrics.prometheus.HikariCPCollector;
import org.apache.flink.cdc.connectors.shaded.com.zaxxer.hikari.metrics.prometheus.PrometheusMetricsTracker;

public class PrometheusMetricsTrackerFactory
implements MetricsTrackerFactory {
    private static final Map<CollectorRegistry, RegistrationStatus> registrationStatuses = new ConcurrentHashMap<CollectorRegistry, RegistrationStatus>();
    private final HikariCPCollector collector = new HikariCPCollector();
    private final CollectorRegistry collectorRegistry;

    public PrometheusMetricsTrackerFactory() {
        this(CollectorRegistry.defaultRegistry);
    }

    public PrometheusMetricsTrackerFactory(CollectorRegistry collectorRegistry) {
        this.collectorRegistry = collectorRegistry;
    }

    @Override
    public IMetricsTracker create(String poolName, PoolStats poolStats) {
        this.registerCollector(this.collector, this.collectorRegistry);
        this.collector.add(poolName, poolStats);
        return new PrometheusMetricsTracker(poolName, this.collectorRegistry, this.collector);
    }

    private void registerCollector(Collector collector, CollectorRegistry collectorRegistry) {
        if (registrationStatuses.putIfAbsent(collectorRegistry, RegistrationStatus.REGISTERED) == null) {
            collector.register(collectorRegistry);
        }
    }

    static enum RegistrationStatus {
        REGISTERED;

    }
}

