/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mysql.source.assigners;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum AssignerStatus {
    INITIAL_ASSIGNING(0){

        @Override
        public AssignerStatus getNextStatus() {
            return INITIAL_ASSIGNING_FINISHED;
        }

        @Override
        public AssignerStatus onFinish() {
            LOG.info("Assigner status changes from INITIAL_ASSIGNING to INITIAL_ASSIGNING_FINISHED");
            return this.getNextStatus();
        }
    }
    ,
    INITIAL_ASSIGNING_FINISHED(1){

        @Override
        public AssignerStatus getNextStatus() {
            return NEWLY_ADDED_ASSIGNING;
        }

        @Override
        public AssignerStatus startAssignNewlyTables() {
            LOG.info("Assigner status changes from INITIAL_ASSIGNING_FINISHED to NEW_ADDED_ASSIGNING");
            return this.getNextStatus();
        }
    }
    ,
    NEWLY_ADDED_ASSIGNING(2){

        @Override
        public AssignerStatus getNextStatus() {
            return NEWLY_ADDED_ASSIGNING_SNAPSHOT_FINISHED;
        }

        @Override
        public AssignerStatus onFinish() {
            LOG.info("Assigner status changes from NEWLY_ADDED_ASSIGNING to NEWLY_ADDED_ASSIGNING_SNAPSHOT_FINISHED");
            return this.getNextStatus();
        }
    }
    ,
    NEWLY_ADDED_ASSIGNING_SNAPSHOT_FINISHED(3){

        @Override
        public AssignerStatus getNextStatus() {
            return NEWLY_ADDED_ASSIGNING_FINISHED;
        }

        @Override
        public AssignerStatus onBinlogSplitUpdated() {
            LOG.info("Assigner status changes from NEWLY_ADDED_ASSIGNING_SNAPSHOT_FINISHED to NEWLY_ADDED_ASSIGNING_FINISHED");
            return this.getNextStatus();
        }
    }
    ,
    NEWLY_ADDED_ASSIGNING_FINISHED(4){

        @Override
        public AssignerStatus getNextStatus() {
            return NEWLY_ADDED_ASSIGNING;
        }

        @Override
        public AssignerStatus startAssignNewlyTables() {
            LOG.info("Assigner status changes from NEWLY_ADDED_ASSIGNING_FINISHED to NEWLY_ADDED_ASSIGNING");
            return this.getNextStatus();
        }
    };

    private static final Logger LOG;
    private final int statusCode;

    private AssignerStatus(int statusCode) {
        this.statusCode = statusCode;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public abstract AssignerStatus getNextStatus();

    public AssignerStatus onFinish() {
        throw new IllegalStateException(String.format("Invalid call, assigner under %s state can not call onFinish()", new Object[]{AssignerStatus.fromStatusCode(this.getStatusCode())}));
    }

    public AssignerStatus startAssignNewlyTables() {
        throw new IllegalStateException(String.format("Invalid call, assigner under %s state can not call startAssignNewlyTables()", new Object[]{AssignerStatus.fromStatusCode(this.getStatusCode())}));
    }

    public AssignerStatus onBinlogSplitUpdated() {
        throw new IllegalStateException(String.format("Invalid call, assigner under %s state can not call onBinlogSplitUpdated()", new Object[]{AssignerStatus.fromStatusCode(this.getStatusCode())}));
    }

    public static AssignerStatus fromStatusCode(int statusCode) {
        switch (statusCode) {
            case 0: {
                return INITIAL_ASSIGNING;
            }
            case 1: {
                return INITIAL_ASSIGNING_FINISHED;
            }
            case 2: {
                return NEWLY_ADDED_ASSIGNING;
            }
            case 3: {
                return NEWLY_ADDED_ASSIGNING_SNAPSHOT_FINISHED;
            }
            case 4: {
                return NEWLY_ADDED_ASSIGNING_FINISHED;
            }
        }
        throw new IllegalStateException(String.format("Invalid status code %s,the valid code range is [0, 4]", statusCode));
    }

    public static boolean isSnapshotAssigningFinished(AssignerStatus assignerStatus) {
        return assignerStatus == INITIAL_ASSIGNING_FINISHED || assignerStatus == NEWLY_ADDED_ASSIGNING_SNAPSHOT_FINISHED;
    }

    public static boolean isAssigningFinished(AssignerStatus assignerStatus) {
        return assignerStatus == INITIAL_ASSIGNING_FINISHED || assignerStatus == NEWLY_ADDED_ASSIGNING_FINISHED;
    }

    public static boolean isAssigningSnapshotSplits(AssignerStatus assignerStatus) {
        return assignerStatus == INITIAL_ASSIGNING || assignerStatus == NEWLY_ADDED_ASSIGNING;
    }

    public static boolean isInitialAssigningFinished(AssignerStatus assignerStatus) {
        return assignerStatus == INITIAL_ASSIGNING_FINISHED;
    }

    public static boolean isNewlyAddedAssigningFinished(AssignerStatus assignerStatus) {
        return assignerStatus == NEWLY_ADDED_ASSIGNING_FINISHED;
    }

    public static boolean isNewlyAddedAssigningSnapshotFinished(AssignerStatus assignerStatus) {
        return assignerStatus == NEWLY_ADDED_ASSIGNING_SNAPSHOT_FINISHED;
    }

    static {
        LOG = LoggerFactory.getLogger(AssignerStatus.class);
    }
}

