/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.mysql.binlog.network.protocol.command;

import com.github.shyiko.mysql.binlog.io.ByteArrayOutputStream;
import com.github.shyiko.mysql.binlog.network.protocol.command.Command;
import com.github.shyiko.mysql.binlog.network.protocol.command.CommandUtils;
import java.io.IOException;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class AuthenticateSHA2Command
implements Command {
    private String schema;
    private String username;
    private String password;
    private String scramble;
    private int clientCapabilities;
    private int collation;
    private boolean rawPassword = false;

    public AuthenticateSHA2Command(String schema, String username, String password, String scramble, int collation) {
        this.schema = schema;
        this.username = username;
        this.password = password;
        this.scramble = scramble;
        this.collation = collation;
    }

    public AuthenticateSHA2Command(String scramble, String password) {
        this.rawPassword = true;
        this.password = password;
        this.scramble = scramble;
    }

    public void setClientCapabilities(int clientCapabilities) {
        this.clientCapabilities = clientCapabilities;
    }

    @Override
    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        if (this.rawPassword) {
            byte[] passwordSHA1 = this.encodePassword();
            buffer.write(passwordSHA1);
            return buffer.toByteArray();
        }
        int clientCapabilities = this.clientCapabilities;
        if (clientCapabilities == 0) {
            clientCapabilities |= 4;
            clientCapabilities |= 0x200;
            clientCapabilities |= 0x8000;
            clientCapabilities |= 0x80000;
            clientCapabilities |= 0x200000;
            if (this.schema != null) {
                clientCapabilities |= 8;
            }
        }
        buffer.writeInteger(clientCapabilities, 4);
        buffer.writeInteger(0, 4);
        buffer.writeInteger(this.collation, 1);
        for (int i = 0; i < 23; ++i) {
            buffer.write(0);
        }
        buffer.writeZeroTerminatedString(this.username);
        byte[] passwordSHA1 = this.encodePassword();
        buffer.writeInteger(passwordSHA1.length, 1);
        buffer.write(passwordSHA1);
        if (this.schema != null) {
            buffer.writeZeroTerminatedString(this.schema);
        }
        buffer.writeZeroTerminatedString("caching_sha2_password");
        return buffer.toByteArray();
    }

    private byte[] encodePassword() {
        if (this.password == null || "".equals(this.password)) {
            return new byte[0];
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            int CACHING_SHA2_DIGEST_LENGTH = 32;
            byte[] dig1 = new byte[CACHING_SHA2_DIGEST_LENGTH];
            byte[] dig2 = new byte[CACHING_SHA2_DIGEST_LENGTH];
            byte[] scramble1 = new byte[CACHING_SHA2_DIGEST_LENGTH];
            md.update(this.password.getBytes(), 0, this.password.getBytes().length);
            md.digest(dig1, 0, CACHING_SHA2_DIGEST_LENGTH);
            md.reset();
            md.update(dig1, 0, dig1.length);
            md.digest(dig2, 0, CACHING_SHA2_DIGEST_LENGTH);
            md.reset();
            md.update(dig2, 0, dig1.length);
            md.update(this.scramble.getBytes(), 0, this.scramble.getBytes().length);
            md.digest(scramble1, 0, CACHING_SHA2_DIGEST_LENGTH);
            return CommandUtils.xor(dig1, scramble1);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
        catch (DigestException e) {
            throw new RuntimeException(e);
        }
    }
}

