/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.DebeziumException;
import io.debezium.pipeline.spi.Offsets;
import io.debezium.relational.HistorizedRelationalDatabaseConnectorConfig;
import io.debezium.relational.Key;
import io.debezium.relational.RelationalDatabaseSchema;
import io.debezium.relational.TableId;
import io.debezium.relational.TableSchemaBuilder;
import io.debezium.relational.Tables;
import io.debezium.relational.ddl.DdlParser;
import io.debezium.relational.history.DatabaseHistory;
import io.debezium.relational.history.TableChanges;
import io.debezium.schema.HistorizedDatabaseSchema;
import io.debezium.schema.SchemaChangeEvent;
import io.debezium.schema.TopicSelector;
import java.util.Objects;

public abstract class HistorizedRelationalDatabaseSchema
extends RelationalDatabaseSchema
implements HistorizedDatabaseSchema<TableId> {
    protected final DatabaseHistory databaseHistory;
    private boolean recoveredTables;

    protected HistorizedRelationalDatabaseSchema(HistorizedRelationalDatabaseConnectorConfig config, TopicSelector<TableId> topicSelector, Tables.TableFilter tableFilter, Tables.ColumnNameFilter columnFilter, TableSchemaBuilder schemaBuilder, boolean tableIdCaseInsensitive, Key.KeyMapper customKeysMapper) {
        super(config, topicSelector, tableFilter, columnFilter, schemaBuilder, tableIdCaseInsensitive, customKeysMapper);
        this.databaseHistory = config.getDatabaseHistory();
        this.databaseHistory.start();
    }

    @Override
    public void recover(Offsets<?, ?> offsets) {
        boolean hasNonNullOffsets = offsets.getOffsets().values().stream().anyMatch(Objects::nonNull);
        if (!hasNonNullOffsets) {
            return;
        }
        if (!this.databaseHistory.exists()) {
            String msg = "The db history topic or its content is fully or partially missing. Please check database history topic configuration and re-execute the snapshot.";
            throw new DebeziumException(msg);
        }
        this.databaseHistory.recover(offsets, this.tables(), this.getDdlParser());
        this.recoveredTables = !this.tableIds().isEmpty();
        for (TableId tableId : this.tableIds()) {
            this.buildAndRegisterSchema(this.tableFor(tableId));
        }
    }

    @Override
    public void close() {
        this.databaseHistory.stop();
    }

    @Override
    public void initializeStorage() {
        if (!this.databaseHistory.storageExists()) {
            this.databaseHistory.initializeStorage();
        }
    }

    protected abstract DdlParser getDdlParser();

    protected void record(SchemaChangeEvent schemaChange, TableChanges tableChanges) {
        this.databaseHistory.record(schemaChange.getPartition(), schemaChange.getOffset(), schemaChange.getDatabase(), schemaChange.getSchema(), schemaChange.getDdl(), tableChanges);
    }

    @Override
    public boolean tableInformationComplete() {
        return this.recoveredTables;
    }

    @Override
    public boolean storeOnlyCapturedTables() {
        return this.databaseHistory.storeOnlyCapturedTables();
    }

    public boolean skipUnparseableDdlStatements() {
        return this.databaseHistory.skipUnparseableDdlStatements();
    }

    @Override
    public boolean isHistorized() {
        return true;
    }
}

