/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mongodb.source.assigners.splitters;

import io.debezium.relational.TableId;
import io.debezium.relational.history.TableChanges;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.apache.flink.cdc.common.annotation.Internal;
import org.apache.flink.cdc.connectors.base.source.meta.split.SnapshotSplit;
import org.apache.flink.cdc.connectors.mongodb.source.assigners.splitters.SplitContext;
import org.apache.flink.cdc.connectors.mongodb.source.assigners.splitters.SplitStrategy;
import org.apache.flink.cdc.connectors.mongodb.source.dialect.MongoDBDialect;
import org.apache.flink.cdc.connectors.mongodb.source.utils.ChunkUtils;

@Internal
public class SingleSplitStrategy
implements SplitStrategy {
    public static final SingleSplitStrategy INSTANCE = new SingleSplitStrategy();

    private SingleSplitStrategy() {
    }

    @Override
    public Collection<SnapshotSplit> split(SplitContext splitContext) {
        TableId collectionId = splitContext.getCollectionId();
        HashMap<TableId, TableChanges.TableChange> schema = new HashMap<TableId, TableChanges.TableChange>();
        schema.put(collectionId, MongoDBDialect.collectionSchema(collectionId));
        SnapshotSplit snapshotSplit = new SnapshotSplit(collectionId, 0, this.shardKeysToRowType(Collections.singleton("_id")), ChunkUtils.minLowerBoundOfId(), ChunkUtils.maxUpperBoundOfId(), null, schema);
        return Collections.singletonList(snapshotSplit);
    }
}

