/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mongodb.source.assigners.splitters;

import com.mongodb.MongoQueryException;
import com.mongodb.client.MongoClient;
import io.debezium.relational.TableId;
import io.debezium.relational.history.TableChanges;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.flink.cdc.common.annotation.Internal;
import org.apache.flink.cdc.connectors.base.source.meta.split.SnapshotSplit;
import org.apache.flink.cdc.connectors.mongodb.source.assigners.splitters.SampleBucketSplitStrategy;
import org.apache.flink.cdc.connectors.mongodb.source.assigners.splitters.SplitContext;
import org.apache.flink.cdc.connectors.mongodb.source.assigners.splitters.SplitStrategy;
import org.apache.flink.cdc.connectors.mongodb.source.dialect.MongoDBDialect;
import org.apache.flink.cdc.connectors.mongodb.source.utils.MongoUtils;
import org.apache.flink.table.types.logical.RowType;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class ShardedSplitStrategy
implements SplitStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(ShardedSplitStrategy.class);
    public static final ShardedSplitStrategy INSTANCE = new ShardedSplitStrategy();

    private ShardedSplitStrategy() {
    }

    @Override
    public Collection<SnapshotSplit> split(SplitContext splitContext) {
        List<BsonDocument> chunks;
        BsonDocument collectionMetadata;
        TableId collectionId = splitContext.getCollectionId();
        MongoClient mongoClient = splitContext.getMongoClient();
        try {
            collectionMetadata = MongoUtils.readCollectionMetadata(mongoClient, collectionId);
            if (!this.isValidShardedCollection(collectionMetadata) || !this.isNotShardedByHash(collectionMetadata)) {
                LOG.warn("Collection {} does not appear to be sharded, or shared by hash, fallback to SampleSplitter.", (Object)collectionId);
                return SampleBucketSplitStrategy.INSTANCE.split(splitContext);
            }
            chunks = MongoUtils.readChunks(mongoClient, collectionMetadata);
        }
        catch (MongoQueryException e) {
            if (e.getErrorCode() == 13) {
                LOG.warn("Unauthorized to read config.collections or config.chunks: {}, fallback to SampleSplitter.", (Object)e.getErrorMessage());
            } else {
                LOG.warn("Read config.chunks collection failed: {}, fallback to SampleSplitter", (Object)e.getErrorMessage());
            }
            return SampleBucketSplitStrategy.INSTANCE.split(splitContext);
        }
        if (chunks.isEmpty()) {
            LOG.warn("Collection {} does not appear to be sharded, fallback to SampleSplitter.", (Object)collectionId);
            return SampleBucketSplitStrategy.INSTANCE.split(splitContext);
        }
        BsonDocument splitKeys = collectionMetadata.getDocument("key");
        RowType rowType = this.shardKeysToRowType(splitKeys);
        HashMap<TableId, TableChanges.TableChange> schema = new HashMap<TableId, TableChanges.TableChange>();
        schema.put(collectionId, MongoDBDialect.collectionSchema(collectionId));
        ArrayList<SnapshotSplit> snapshotSplits = new ArrayList<SnapshotSplit>(chunks.size());
        for (int i = 0; i < chunks.size(); ++i) {
            BsonDocument chunk = chunks.get(i);
            snapshotSplits.add(new SnapshotSplit(collectionId, i, rowType, new Object[]{splitKeys, chunk.getDocument("min")}, new Object[]{splitKeys, chunk.getDocument("max")}, null, schema));
        }
        return snapshotSplits;
    }

    private boolean isValidShardedCollection(BsonDocument collectionMetadata) {
        return collectionMetadata != null && !collectionMetadata.getBoolean("dropped", BsonBoolean.FALSE).getValue();
    }

    private boolean isNotShardedByHash(BsonDocument collectionMetadata) {
        BsonDocument splitKeys = collectionMetadata.getDocument("key");
        return splitKeys.values().stream().noneMatch(v -> v.isString() && v.asString().getValue().equals("hashed"));
    }
}

