/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoDriverInformation;
import com.mongodb.assertions.Assertions;
import com.mongodb.lang.Nullable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.bson.BsonBinaryWriter;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.EncoderContext;
import org.bson.io.BasicOutputBuffer;

public final class ClientMetadataHelper {
    private static final String SEPARATOR = "|";
    private static final int MAXIMUM_CLIENT_METADATA_ENCODED_SIZE = 512;

    static String getOperatingSystemType(String operatingSystemName) {
        if (ClientMetadataHelper.nameStartsWith(operatingSystemName, "linux")) {
            return "Linux";
        }
        if (ClientMetadataHelper.nameStartsWith(operatingSystemName, "mac")) {
            return "Darwin";
        }
        if (ClientMetadataHelper.nameStartsWith(operatingSystemName, "windows")) {
            return "Windows";
        }
        if (ClientMetadataHelper.nameStartsWith(operatingSystemName, "hp-ux", "aix", "irix", "solaris", "sunos")) {
            return "Unix";
        }
        return "unknown";
    }

    private static String getOperatingSystemName() {
        return System.getProperty("os.name", "unknown");
    }

    private static boolean nameStartsWith(String name, String ... prefixes) {
        for (String prefix : prefixes) {
            if (!name.toLowerCase().startsWith(prefix.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static BsonDocument createClientMetadataDocument(@Nullable String applicationName, @Nullable MongoDriverInformation mongoDriverInformation) {
        if (applicationName != null) {
            Assertions.isTrueArgument("applicationName UTF-8 encoding length <= 128", applicationName.getBytes(StandardCharsets.UTF_8).length <= 128);
        }
        BsonDocument client = new BsonDocument();
        ClientMetadataHelper.tryWithLimit(client, d -> ClientMetadataHelper.putAtPath(d, "application.name", applicationName));
        MongoDriverInformation baseDriverInfor = ClientMetadataHelper.getDriverInformation(null);
        ClientMetadataHelper.tryWithLimit(client, d -> {
            ClientMetadataHelper.putAtPath(d, "driver.name", ClientMetadataHelper.listToString(baseDriverInfor.getDriverNames()));
            ClientMetadataHelper.putAtPath(d, "driver.version", ClientMetadataHelper.listToString(baseDriverInfor.getDriverVersions()));
        });
        ClientMetadataHelper.tryWithLimit(client, d -> ClientMetadataHelper.putAtPath(d, "os.type", ClientMetadataHelper.getOperatingSystemType(ClientMetadataHelper.getOperatingSystemName())));
        MongoDriverInformation fullDriverInfo = ClientMetadataHelper.getDriverInformation(mongoDriverInformation);
        ClientMetadataHelper.tryWithLimit(client, d -> {
            ClientMetadataHelper.putAtPath(d, "driver.name", ClientMetadataHelper.listToString(fullDriverInfo.getDriverNames()));
            ClientMetadataHelper.putAtPath(d, "driver.version", ClientMetadataHelper.listToString(fullDriverInfo.getDriverVersions()));
        });
        Environment environment = ClientMetadataHelper.getEnvironment();
        ClientMetadataHelper.tryWithLimit(client, d -> ClientMetadataHelper.putAtPath(d, "platform", ClientMetadataHelper.listToString(baseDriverInfor.getDriverPlatforms())));
        ClientMetadataHelper.tryWithLimit(client, d -> ClientMetadataHelper.putAtPath(d, "platform", ClientMetadataHelper.listToString(fullDriverInfo.getDriverPlatforms())));
        ClientMetadataHelper.tryWithLimit(client, d -> ClientMetadataHelper.putAtPath(d, "env.name", environment.getName()));
        ClientMetadataHelper.tryWithLimit(client, d -> ClientMetadataHelper.putAtPath(d, "os.name", ClientMetadataHelper.getOperatingSystemName()));
        ClientMetadataHelper.tryWithLimit(client, d -> ClientMetadataHelper.putAtPath(d, "os.architecture", System.getProperty("os.arch", "unknown")));
        ClientMetadataHelper.tryWithLimit(client, d -> ClientMetadataHelper.putAtPath(d, "os.version", System.getProperty("os.version", "unknown")));
        ClientMetadataHelper.tryWithLimit(client, d -> ClientMetadataHelper.putAtPath(d, "env.timeout_sec", environment.getTimeoutSec()));
        ClientMetadataHelper.tryWithLimit(client, d -> ClientMetadataHelper.putAtPath(d, "env.memory_mb", environment.getMemoryMb()));
        ClientMetadataHelper.tryWithLimit(client, d -> ClientMetadataHelper.putAtPath(d, "env.region", environment.getRegion()));
        return client;
    }

    private static void putAtPath(BsonDocument d, String path, @Nullable String value) {
        if (value == null) {
            return;
        }
        ClientMetadataHelper.putAtPath(d, path, new BsonString(value));
    }

    private static void putAtPath(BsonDocument d, String path, @Nullable Integer value) {
        if (value == null) {
            return;
        }
        ClientMetadataHelper.putAtPath(d, path, new BsonInt32(value));
    }

    private static void putAtPath(BsonDocument d, String path, @Nullable BsonValue value) {
        if (value == null) {
            return;
        }
        String[] split = path.split("\\.", 2);
        String first = split[0];
        if (split.length == 1) {
            d.append(first, value);
        } else {
            BsonDocument child;
            if (d.containsKey(first)) {
                child = d.getDocument(first);
            } else {
                child = new BsonDocument();
                d.append(first, child);
            }
            String rest = split[1];
            ClientMetadataHelper.putAtPath(child, rest, value);
        }
    }

    private static void tryWithLimit(BsonDocument document, Consumer<BsonDocument> modifier) {
        try {
            BsonDocument temp = document.clone();
            modifier.accept(temp);
            if (!ClientMetadataHelper.clientMetadataDocumentTooLarge(temp)) {
                modifier.accept(document);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static boolean clientMetadataDocumentTooLarge(BsonDocument document) {
        BasicOutputBuffer buffer = new BasicOutputBuffer(512);
        new BsonDocumentCodec().encode((BsonWriter)new BsonBinaryWriter(buffer), document, EncoderContext.builder().build());
        return buffer.getPosition() > 512;
    }

    @Nullable
    private static Integer getEnvInteger(String name) {
        try {
            String value = System.getenv(name);
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    static Environment getEnvironment() {
        ArrayList<Environment> result = new ArrayList<Environment>();
        String awsExecutionEnv = System.getenv("AWS_EXECUTION_ENV");
        if (System.getenv("VERCEL") != null) {
            result.add(Environment.VERCEL);
        }
        if (awsExecutionEnv != null && awsExecutionEnv.startsWith("AWS_Lambda_") || System.getenv("AWS_LAMBDA_RUNTIME_API") != null) {
            result.add(Environment.AWS_LAMBDA);
        }
        if (System.getenv("FUNCTIONS_WORKER_RUNTIME") != null) {
            result.add(Environment.AZURE_FUNC);
        }
        if (System.getenv("K_SERVICE") != null || System.getenv("FUNCTION_NAME") != null) {
            result.add(Environment.GCP_FUNC);
        }
        if (result.equals(Arrays.asList(Environment.VERCEL, Environment.AWS_LAMBDA))) {
            return Environment.VERCEL;
        }
        if (result.size() != 1) {
            return Environment.UNKNOWN;
        }
        return (Environment)((Object)result.get(0));
    }

    static MongoDriverInformation getDriverInformation(@Nullable MongoDriverInformation mongoDriverInformation) {
        MongoDriverInformation.Builder builder = mongoDriverInformation != null ? MongoDriverInformation.builder(mongoDriverInformation) : MongoDriverInformation.builder();
        return builder.driverName("mongo-java-driver").driverVersion("4.11.2").driverPlatform(String.format("Java/%s/%s", System.getProperty("java.vendor", "unknown-vendor"), System.getProperty("java.runtime.version", "unknown-version"))).build();
    }

    private static String listToString(List<String> listOfStrings) {
        StringBuilder stringBuilder = new StringBuilder();
        int i = 0;
        for (String val : listOfStrings) {
            if (i > 0) {
                stringBuilder.append(SEPARATOR);
            }
            stringBuilder.append(val);
            ++i;
        }
        return stringBuilder.toString();
    }

    private ClientMetadataHelper() {
    }

    private static enum Environment {
        AWS_LAMBDA("aws.lambda"),
        AZURE_FUNC("azure.func"),
        GCP_FUNC("gcp.func"),
        VERCEL("vercel"),
        UNKNOWN(null);

        @Nullable
        private final String name;

        private Environment(String name) {
            this.name = name;
        }

        @Nullable
        public String getName() {
            return this.name;
        }

        @Nullable
        public Integer getTimeoutSec() {
            switch (this) {
                case GCP_FUNC: {
                    return ClientMetadataHelper.getEnvInteger("FUNCTION_TIMEOUT_SEC");
                }
            }
            return null;
        }

        @Nullable
        public Integer getMemoryMb() {
            switch (this) {
                case AWS_LAMBDA: {
                    return ClientMetadataHelper.getEnvInteger("AWS_LAMBDA_FUNCTION_MEMORY_SIZE");
                }
                case GCP_FUNC: {
                    return ClientMetadataHelper.getEnvInteger("FUNCTION_MEMORY_MB");
                }
            }
            return null;
        }

        @Nullable
        public String getRegion() {
            switch (this) {
                case AWS_LAMBDA: {
                    return System.getenv("AWS_REGION");
                }
                case GCP_FUNC: {
                    return System.getenv("FUNCTION_REGION");
                }
                case VERCEL: {
                    return System.getenv("VERCEL_REGION");
                }
            }
            return null;
        }
    }
}

