/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mongodb.table;

import com.mongodb.MongoNamespace;
import java.time.ZoneId;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.cdc.connectors.base.options.StartupOptions;
import org.apache.flink.cdc.connectors.mongodb.MongoDBSource;
import org.apache.flink.cdc.connectors.mongodb.source.MongoDBSourceBuilder;
import org.apache.flink.cdc.connectors.mongodb.source.utils.CollectionDiscoveryUtils;
import org.apache.flink.cdc.connectors.mongodb.table.MongoDBConnectorDeserializationSchema;
import org.apache.flink.cdc.connectors.mongodb.table.MongoDBConnectorFullChangelogDeserializationSchema;
import org.apache.flink.cdc.connectors.mongodb.table.MongoDBReadableMetadata;
import org.apache.flink.cdc.debezium.table.MetadataConverter;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.SourceFunctionProvider;
import org.apache.flink.table.connector.source.SourceProvider;
import org.apache.flink.table.connector.source.abilities.SupportsReadingMetadata;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDBTableSource
implements ScanTableSource,
SupportsReadingMetadata {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDBTableSource.class);
    private final ResolvedSchema physicalSchema;
    private final String scheme;
    private final String hosts;
    private final String connectionOptions;
    private final String username;
    private final String password;
    private final String database;
    private final String collection;
    private final StartupOptions startupOptions;
    private final Integer initialSnapshottingQueueSize;
    private final Integer initialSnapshottingMaxThreads;
    private final String initialSnapshottingPipeline;
    private final Integer batchSize;
    private final Integer pollMaxBatchSize;
    private final Integer pollAwaitTimeMillis;
    private final Integer heartbeatIntervalMillis;
    private final ZoneId localTimeZone;
    private final boolean enableParallelRead;
    private final Integer splitMetaGroupSize;
    private final Integer splitSizeMB;
    private final Integer samplesPerChunk;
    private final boolean closeIdlerReaders;
    private final boolean enableFullDocPrePostImage;
    private final boolean noCursorTimeout;
    private final boolean skipSnapshotBackfill;
    private final boolean scanNewlyAddedTableEnabled;
    private final boolean assignUnboundedChunkFirst;
    protected DataType producedDataType;
    protected List<String> metadataKeys;

    public MongoDBTableSource(ResolvedSchema physicalSchema, String scheme, String hosts, @Nullable String username, @Nullable String password, @Nullable String database, @Nullable String collection, @Nullable String connectionOptions, StartupOptions startupOptions, @Nullable Integer initialSnapshottingQueueSize, @Nullable Integer initialSnapshottingMaxThreads, @Nullable String initialSnapshottingPipeline, @Nullable Integer batchSize, @Nullable Integer pollMaxBatchSize, @Nullable Integer pollAwaitTimeMillis, @Nullable Integer heartbeatIntervalMillis, ZoneId localTimeZone, boolean enableParallelRead, @Nullable Integer splitMetaGroupSize, @Nullable Integer splitSizeMB, @Nullable Integer samplesPerChunk, boolean closeIdlerReaders, boolean enableFullDocPrePostImage, boolean noCursorTimeout, boolean skipSnapshotBackfill, boolean scanNewlyAddedTableEnabled, boolean assignUnboundedChunkFirst) {
        this.physicalSchema = physicalSchema;
        this.scheme = (String)Preconditions.checkNotNull((Object)scheme);
        this.hosts = (String)Preconditions.checkNotNull((Object)hosts);
        this.username = username;
        this.password = password;
        this.database = database;
        this.collection = collection;
        this.connectionOptions = connectionOptions;
        this.startupOptions = (StartupOptions)Preconditions.checkNotNull((Object)startupOptions);
        this.initialSnapshottingQueueSize = initialSnapshottingQueueSize;
        this.initialSnapshottingMaxThreads = initialSnapshottingMaxThreads;
        this.initialSnapshottingPipeline = initialSnapshottingPipeline;
        this.batchSize = batchSize;
        this.pollMaxBatchSize = pollMaxBatchSize;
        this.pollAwaitTimeMillis = pollAwaitTimeMillis;
        this.heartbeatIntervalMillis = heartbeatIntervalMillis;
        this.localTimeZone = localTimeZone;
        this.producedDataType = physicalSchema.toPhysicalRowDataType();
        this.metadataKeys = Collections.emptyList();
        this.enableParallelRead = enableParallelRead;
        this.splitMetaGroupSize = splitMetaGroupSize;
        this.splitSizeMB = splitSizeMB;
        this.samplesPerChunk = samplesPerChunk;
        this.closeIdlerReaders = closeIdlerReaders;
        this.enableFullDocPrePostImage = enableFullDocPrePostImage;
        this.noCursorTimeout = noCursorTimeout;
        this.skipSnapshotBackfill = skipSnapshotBackfill;
        this.scanNewlyAddedTableEnabled = scanNewlyAddedTableEnabled;
        this.assignUnboundedChunkFirst = assignUnboundedChunkFirst;
    }

    public ChangelogMode getChangelogMode() {
        if (this.enableFullDocPrePostImage) {
            return ChangelogMode.all();
        }
        return ChangelogMode.upsert();
    }

    public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext scanContext) {
        RowType physicalDataType = (RowType)this.physicalSchema.toPhysicalRowDataType().getLogicalType();
        MetadataConverter[] metadataConverters = this.getMetadataConverters();
        TypeInformation typeInfo = scanContext.createTypeInformation(this.producedDataType);
        MongoDBConnectorDeserializationSchema deserializer = this.enableFullDocPrePostImage ? new MongoDBConnectorFullChangelogDeserializationSchema(physicalDataType, metadataConverters, (TypeInformation<RowData>)typeInfo, this.localTimeZone) : new MongoDBConnectorDeserializationSchema(physicalDataType, metadataConverters, (TypeInformation<RowData>)typeInfo, this.localTimeZone);
        String databaseList = null;
        String collectionList = null;
        if (StringUtils.isNotEmpty((CharSequence)this.database) && StringUtils.isNotEmpty((CharSequence)this.collection)) {
            if (!CollectionDiscoveryUtils.inferIsRegularExpression(this.database) && !CollectionDiscoveryUtils.inferIsRegularExpression(this.collection)) {
                MongoNamespace.checkDatabaseNameValidity(this.database);
                MongoNamespace.checkCollectionNameValidity(this.collection);
                databaseList = this.database;
                collectionList = this.database + "." + this.collection;
            } else {
                databaseList = this.database;
                collectionList = this.collection;
            }
        } else if (StringUtils.isNotEmpty((CharSequence)this.database)) {
            databaseList = this.database;
        } else if (StringUtils.isNotEmpty((CharSequence)this.collection)) {
            collectionList = this.collection;
        }
        if (this.enableParallelRead) {
            MongoDBSourceBuilder<RowData> builder = org.apache.flink.cdc.connectors.mongodb.source.MongoDBSource.builder().scheme(this.scheme).hosts(this.hosts).closeIdleReaders(this.closeIdlerReaders).scanFullChangelog(this.enableFullDocPrePostImage).startupOptions(this.startupOptions).skipSnapshotBackfill(this.skipSnapshotBackfill).scanNewlyAddedTableEnabled(this.scanNewlyAddedTableEnabled).deserializer(deserializer).disableCursorTimeout(this.noCursorTimeout).assignUnboundedChunkFirst(this.assignUnboundedChunkFirst);
            Optional.ofNullable(databaseList).ifPresent(xva$0 -> builder.databaseList((String)xva$0));
            Optional.ofNullable(collectionList).ifPresent(xva$0 -> builder.collectionList((String)xva$0));
            Optional.ofNullable(this.username).ifPresent(builder::username);
            Optional.ofNullable(this.password).ifPresent(builder::password);
            Optional.ofNullable(this.connectionOptions).ifPresent(builder::connectionOptions);
            Optional.ofNullable(this.batchSize).ifPresent(builder::batchSize);
            Optional.ofNullable(this.pollMaxBatchSize).ifPresent(builder::pollMaxBatchSize);
            Optional.ofNullable(this.pollAwaitTimeMillis).ifPresent(builder::pollAwaitTimeMillis);
            Optional.ofNullable(this.heartbeatIntervalMillis).ifPresent(builder::heartbeatIntervalMillis);
            Optional.ofNullable(this.splitMetaGroupSize).ifPresent(builder::splitMetaGroupSize);
            Optional.ofNullable(this.splitSizeMB).ifPresent(builder::splitSizeMB);
            Optional.ofNullable(this.samplesPerChunk).ifPresent(builder::samplesPerChunk);
            return SourceProvider.of(builder.build());
        }
        MongoDBSource.Builder<RowData> builder = MongoDBSource.builder().scheme(this.scheme).hosts(this.hosts).scanFullChangelog(this.enableFullDocPrePostImage).startupOptions(this.startupOptions).deserializer(deserializer);
        Optional.ofNullable(databaseList).ifPresent(xva$0 -> builder.databaseList((String)xva$0));
        Optional.ofNullable(collectionList).ifPresent(xva$0 -> builder.collectionList((String)xva$0));
        Optional.ofNullable(this.username).ifPresent(builder::username);
        Optional.ofNullable(this.password).ifPresent(builder::password);
        Optional.ofNullable(this.connectionOptions).ifPresent(builder::connectionOptions);
        Optional.ofNullable(this.initialSnapshottingQueueSize).ifPresent(builder::initialSnapshottingQueueSize);
        Optional.ofNullable(this.initialSnapshottingMaxThreads).ifPresent(builder::initialSnapshottingMaxThreads);
        Optional.ofNullable(this.initialSnapshottingPipeline).ifPresent(builder::initialSnapshottingPipeline);
        Optional.ofNullable(this.batchSize).ifPresent(builder::batchSize);
        Optional.ofNullable(this.pollMaxBatchSize).ifPresent(builder::pollMaxBatchSize);
        Optional.ofNullable(this.pollAwaitTimeMillis).ifPresent(builder::pollAwaitTimeMillis);
        Optional.ofNullable(this.heartbeatIntervalMillis).ifPresent(builder::heartbeatIntervalMillis);
        return SourceFunctionProvider.of(builder.build(), (boolean)false);
    }

    protected MetadataConverter[] getMetadataConverters() {
        if (this.metadataKeys.isEmpty()) {
            return new MetadataConverter[0];
        }
        return (MetadataConverter[])this.metadataKeys.stream().map(key -> Stream.of(MongoDBReadableMetadata.values()).filter(m -> m.getKey().equals(key)).findFirst().orElseThrow(IllegalStateException::new)).map(MongoDBReadableMetadata::getConverter).toArray(MetadataConverter[]::new);
    }

    public Map<String, DataType> listReadableMetadata() {
        return Stream.of(MongoDBReadableMetadata.values()).collect(Collectors.toMap(MongoDBReadableMetadata::getKey, MongoDBReadableMetadata::getDataType));
    }

    public void applyReadableMetadata(List<String> metadataKeys, DataType producedDataType) {
        this.metadataKeys = metadataKeys;
        this.producedDataType = producedDataType;
    }

    public DynamicTableSource copy() {
        MongoDBTableSource source = new MongoDBTableSource(this.physicalSchema, this.scheme, this.hosts, this.username, this.password, this.database, this.collection, this.connectionOptions, this.startupOptions, this.initialSnapshottingQueueSize, this.initialSnapshottingMaxThreads, this.initialSnapshottingPipeline, this.batchSize, this.pollMaxBatchSize, this.pollAwaitTimeMillis, this.heartbeatIntervalMillis, this.localTimeZone, this.enableParallelRead, this.splitMetaGroupSize, this.splitSizeMB, this.samplesPerChunk, this.closeIdlerReaders, this.enableFullDocPrePostImage, this.noCursorTimeout, this.skipSnapshotBackfill, this.scanNewlyAddedTableEnabled, this.assignUnboundedChunkFirst);
        source.metadataKeys = this.metadataKeys;
        source.producedDataType = this.producedDataType;
        return source;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoDBTableSource that = (MongoDBTableSource)o;
        return Objects.equals(this.physicalSchema, that.physicalSchema) && Objects.equals(this.scheme, that.scheme) && Objects.equals(this.hosts, that.hosts) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password) && Objects.equals(this.database, that.database) && Objects.equals(this.collection, that.collection) && Objects.equals(this.connectionOptions, that.connectionOptions) && Objects.equals(this.startupOptions, that.startupOptions) && Objects.equals(this.initialSnapshottingQueueSize, that.initialSnapshottingQueueSize) && Objects.equals(this.initialSnapshottingMaxThreads, that.initialSnapshottingMaxThreads) && Objects.equals(this.initialSnapshottingPipeline, that.initialSnapshottingPipeline) && Objects.equals(this.batchSize, that.batchSize) && Objects.equals(this.pollMaxBatchSize, that.pollMaxBatchSize) && Objects.equals(this.pollAwaitTimeMillis, that.pollAwaitTimeMillis) && Objects.equals(this.heartbeatIntervalMillis, that.heartbeatIntervalMillis) && Objects.equals(this.localTimeZone, that.localTimeZone) && Objects.equals(this.enableParallelRead, that.enableParallelRead) && Objects.equals(this.splitMetaGroupSize, that.splitMetaGroupSize) && Objects.equals(this.splitSizeMB, that.splitSizeMB) && Objects.equals(this.samplesPerChunk, that.samplesPerChunk) && Objects.equals(this.producedDataType, that.producedDataType) && Objects.equals(this.metadataKeys, that.metadataKeys) && Objects.equals(this.closeIdlerReaders, that.closeIdlerReaders) && Objects.equals(this.enableFullDocPrePostImage, that.enableFullDocPrePostImage) && Objects.equals(this.noCursorTimeout, that.noCursorTimeout) && Objects.equals(this.skipSnapshotBackfill, that.skipSnapshotBackfill) && Objects.equals(this.scanNewlyAddedTableEnabled, that.scanNewlyAddedTableEnabled) && Objects.equals(this.assignUnboundedChunkFirst, that.assignUnboundedChunkFirst);
    }

    public int hashCode() {
        return Objects.hash(this.physicalSchema, this.scheme, this.hosts, this.username, this.password, this.database, this.collection, this.connectionOptions, this.startupOptions, this.initialSnapshottingQueueSize, this.initialSnapshottingMaxThreads, this.initialSnapshottingPipeline, this.batchSize, this.pollMaxBatchSize, this.pollAwaitTimeMillis, this.heartbeatIntervalMillis, this.localTimeZone, this.enableParallelRead, this.splitMetaGroupSize, this.splitSizeMB, this.samplesPerChunk, this.producedDataType, this.metadataKeys, this.closeIdlerReaders, this.enableFullDocPrePostImage, this.noCursorTimeout, this.skipSnapshotBackfill, this.scanNewlyAddedTableEnabled, this.assignUnboundedChunkFirst);
    }

    public String asSummaryString() {
        return "MongoDB-CDC";
    }
}

