/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink;

import com.mongodb.kafka.connect.util.config.ConfigSoftValidator;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class SinkConfigSoftValidator {
    private static final Set<ConfigSoftValidator.ObsoletePropertiesSet> OBSOLETE_PROPERTIES = Collections.unmodifiableSet(Stream.of(ConfigSoftValidator.ObsoletePropertiesSet.unused(Stream.of("max.num.retries", "retries.defer.timeout").collect(Collectors.toSet()), String.format("The sink connector started to rely on retries in the MongoDB Java driver. Remove the property from your configuration as it has no effect. If you have 'retryWrites=false' specified in the '%1$s' configuration property, then retries are disabled for the sink connector; remove 'retryWrites=false' from '%1$s' if you want to enable retries.", "connection.uri"))).collect(Collectors.toSet()));
    private static final Set<ConfigSoftValidator.IncompatiblePropertiesPair> INCOMPATIBLE_PROPERTIES = Collections.unmodifiableSet(Stream.of(ConfigSoftValidator.IncompatiblePropertiesPair.latterIgnored("change.data.capture.handler", "", "post.processor.chain", null), ConfigSoftValidator.IncompatiblePropertiesPair.latterIgnored("change.data.capture.handler", "", "field.renamer.mapping", "[]"), ConfigSoftValidator.IncompatiblePropertiesPair.latterIgnored("change.data.capture.handler", "", "field.renamer.regexp", "[]"), ConfigSoftValidator.IncompatiblePropertiesPair.latterIgnored("change.data.capture.handler", "", "key.projection.list", ""), ConfigSoftValidator.IncompatiblePropertiesPair.latterIgnored("change.data.capture.handler", "", "key.projection.type", "none"), ConfigSoftValidator.IncompatiblePropertiesPair.latterIgnored("change.data.capture.handler", "", "value.projection.list", ""), ConfigSoftValidator.IncompatiblePropertiesPair.latterIgnored("change.data.capture.handler", "", "value.projection.type", "none"), ConfigSoftValidator.IncompatiblePropertiesPair.latterIgnored("change.data.capture.handler", "", "writemodel.strategy", null), ConfigSoftValidator.IncompatiblePropertiesPair.latterIgnored("change.data.capture.handler", "", "document.id.strategy", null), ConfigSoftValidator.IncompatiblePropertiesPair.latterIgnored("change.data.capture.handler", "", "document.id.strategy.overwrite.existing", String.valueOf(false)), ConfigSoftValidator.IncompatiblePropertiesPair.latterIgnored("change.data.capture.handler", "", "document.id.strategy.uuid.format", null), ConfigSoftValidator.IncompatiblePropertiesPair.latterIgnored("change.data.capture.handler", "", "delete.on.null.values", String.valueOf(false))).collect(Collectors.toSet()));

    static void logObsoleteProperties(Collection<String> propertyNames, Consumer<String> logger) {
        ConfigSoftValidator.logObsoleteProperties(OBSOLETE_PROPERTIES, propertyNames, logger);
    }

    static void logIncompatibleProperties(Map<String, String> props, Consumer<String> logger) {
        ConfigSoftValidator.logIncompatibleProperties(INCOMPATIBLE_PROPERTIES, props, logger);
    }

    private SinkConfigSoftValidator() {
    }
}

