/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.Block;
import com.mongodb.ConnectionString;
import com.mongodb.annotations.Immutable;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ProxySettings;
import java.util.concurrent.TimeUnit;

@Immutable
public final class SocketSettings {
    private final long connectTimeoutMS;
    private final long readTimeoutMS;
    private final int receiveBufferSize;
    private final int sendBufferSize;
    private final ProxySettings proxySettings;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(SocketSettings socketSettings) {
        return SocketSettings.builder().applySettings(socketSettings);
    }

    public int getConnectTimeout(TimeUnit timeUnit) {
        return (int)timeUnit.convert(this.connectTimeoutMS, TimeUnit.MILLISECONDS);
    }

    public int getReadTimeout(TimeUnit timeUnit) {
        return (int)timeUnit.convert(this.readTimeoutMS, TimeUnit.MILLISECONDS);
    }

    public ProxySettings getProxySettings() {
        return this.proxySettings;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SocketSettings that = (SocketSettings)o;
        if (this.connectTimeoutMS != that.connectTimeoutMS) {
            return false;
        }
        if (this.readTimeoutMS != that.readTimeoutMS) {
            return false;
        }
        if (this.receiveBufferSize != that.receiveBufferSize) {
            return false;
        }
        if (this.sendBufferSize != that.sendBufferSize) {
            return false;
        }
        return this.proxySettings.equals(that.proxySettings);
    }

    public int hashCode() {
        int result = (int)(this.connectTimeoutMS ^ this.connectTimeoutMS >>> 32);
        result = 31 * result + (int)(this.readTimeoutMS ^ this.readTimeoutMS >>> 32);
        result = 31 * result + this.receiveBufferSize;
        result = 31 * result + this.sendBufferSize;
        result = 31 * result + this.proxySettings.hashCode();
        return result;
    }

    public String toString() {
        return "SocketSettings{connectTimeoutMS=" + this.connectTimeoutMS + ", readTimeoutMS=" + this.readTimeoutMS + ", receiveBufferSize=" + this.receiveBufferSize + ", proxySettings=" + this.proxySettings + '}';
    }

    private SocketSettings(Builder builder) {
        this.connectTimeoutMS = builder.connectTimeoutMS;
        this.readTimeoutMS = builder.readTimeoutMS;
        this.receiveBufferSize = builder.receiveBufferSize;
        this.sendBufferSize = builder.sendBufferSize;
        this.proxySettings = builder.proxySettingsBuilder.build();
    }

    public static final class Builder {
        private long connectTimeoutMS = 10000L;
        private long readTimeoutMS;
        private int receiveBufferSize;
        private int sendBufferSize;
        private ProxySettings.Builder proxySettingsBuilder = ProxySettings.builder();

        private Builder() {
        }

        public Builder applySettings(SocketSettings socketSettings) {
            Assertions.notNull("socketSettings", socketSettings);
            this.connectTimeoutMS = socketSettings.connectTimeoutMS;
            this.readTimeoutMS = socketSettings.readTimeoutMS;
            this.receiveBufferSize = socketSettings.receiveBufferSize;
            this.sendBufferSize = socketSettings.sendBufferSize;
            this.proxySettingsBuilder.applySettings(socketSettings.getProxySettings());
            return this;
        }

        public Builder connectTimeout(int connectTimeout, TimeUnit timeUnit) {
            this.connectTimeoutMS = TimeUnit.MILLISECONDS.convert(connectTimeout, timeUnit);
            return this;
        }

        public Builder readTimeout(int readTimeout, TimeUnit timeUnit) {
            this.readTimeoutMS = TimeUnit.MILLISECONDS.convert(readTimeout, timeUnit);
            return this;
        }

        public Builder receiveBufferSize(int receiveBufferSize) {
            this.receiveBufferSize = receiveBufferSize;
            return this;
        }

        public Builder sendBufferSize(int sendBufferSize) {
            this.sendBufferSize = sendBufferSize;
            return this;
        }

        public Builder applyToProxySettings(Block<ProxySettings.Builder> block) {
            Assertions.notNull("block", block).apply(this.proxySettingsBuilder);
            return this;
        }

        public Builder applyConnectionString(ConnectionString connectionString) {
            Integer socketTimeout;
            Integer connectTimeout = connectionString.getConnectTimeout();
            if (connectTimeout != null) {
                this.connectTimeout(connectTimeout, TimeUnit.MILLISECONDS);
            }
            if ((socketTimeout = connectionString.getSocketTimeout()) != null) {
                this.readTimeout(socketTimeout, TimeUnit.MILLISECONDS);
            }
            this.proxySettingsBuilder.applyConnectionString(connectionString);
            return this;
        }

        public SocketSettings build() {
            return new SocketSettings(this);
        }
    }
}

