/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mongodb.source.assigners.splitters;

import com.mongodb.MongoCommandException;
import com.mongodb.client.MongoClient;
import io.debezium.relational.TableId;
import io.debezium.relational.history.TableChanges;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.flink.cdc.common.annotation.Internal;
import org.apache.flink.cdc.connectors.base.source.meta.split.SnapshotSplit;
import org.apache.flink.cdc.connectors.mongodb.internal.MongoDBEnvelope;
import org.apache.flink.cdc.connectors.mongodb.source.assigners.splitters.SampleBucketSplitStrategy;
import org.apache.flink.cdc.connectors.mongodb.source.assigners.splitters.SingleSplitStrategy;
import org.apache.flink.cdc.connectors.mongodb.source.assigners.splitters.SplitContext;
import org.apache.flink.cdc.connectors.mongodb.source.assigners.splitters.SplitStrategy;
import org.apache.flink.cdc.connectors.mongodb.source.dialect.MongoDBDialect;
import org.apache.flink.cdc.connectors.mongodb.source.utils.ChunkUtils;
import org.apache.flink.cdc.connectors.mongodb.source.utils.MongoUtils;
import org.apache.flink.table.types.logical.RowType;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class SplitVectorSplitStrategy
implements SplitStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(SplitVectorSplitStrategy.class);
    public static final SplitVectorSplitStrategy INSTANCE = new SplitVectorSplitStrategy();

    private SplitVectorSplitStrategy() {
    }

    @Override
    public Collection<SnapshotSplit> split(SplitContext splitContext) {
        BsonDocument splitResult;
        MongoClient mongoClient = splitContext.getMongoClient();
        TableId collectionId = splitContext.getCollectionId();
        int chunkSizeMB = splitContext.getChunkSizeMB();
        BsonDocument keyPattern = new BsonDocument("_id", new BsonInt32(1));
        try {
            splitResult = MongoUtils.splitVector(mongoClient, collectionId, keyPattern, chunkSizeMB);
        }
        catch (MongoCommandException e) {
            if (e.getErrorCode() == 13) {
                LOG.warn("Unauthorized to execute splitVector command: {}, fallback to SampleSplitter", (Object)e.getErrorMessage());
            } else {
                LOG.warn("Execute splitVector command failed: {}, fallback to SampleSplitter", (Object)e.getErrorMessage());
            }
            return SampleBucketSplitStrategy.INSTANCE.split(splitContext);
        }
        if (!MongoUtils.isCommandSucceed(splitResult)) {
            LOG.warn("Could not calculate standalone splits: {}, fallback to SampleSplitter", (Object)splitResult.getString("errmsg"));
            return SampleBucketSplitStrategy.INSTANCE.split(splitContext);
        }
        BsonArray splitKeys = splitResult.getArray("splitKeys");
        if (CollectionUtils.isEmpty((Collection)splitKeys)) {
            return SingleSplitStrategy.INSTANCE.split(splitContext);
        }
        HashMap<TableId, TableChanges.TableChange> schema = new HashMap<TableId, TableChanges.TableChange>();
        schema.put(collectionId, MongoDBDialect.collectionSchema(collectionId));
        RowType rowType = this.shardKeysToRowType(Collections.singleton("_id"));
        ArrayList<SnapshotSplit> snapshotSplits = new ArrayList<SnapshotSplit>(splitKeys.size() + 1);
        BsonValue lowerValue = MongoDBEnvelope.BSON_MIN_KEY;
        for (int i = 0; i < splitKeys.size(); ++i) {
            BsonValue splitKeyValue = splitKeys.get(i).asDocument().get("_id");
            snapshotSplits.add(new SnapshotSplit(collectionId, i, rowType, ChunkUtils.boundOfId(lowerValue), ChunkUtils.boundOfId(splitKeyValue), null, schema));
            lowerValue = splitKeyValue;
        }
        SnapshotSplit lastSplit = new SnapshotSplit(collectionId, splitKeys.size(), rowType, ChunkUtils.boundOfId(lowerValue), ChunkUtils.maxUpperBoundOfId(), null, schema);
        snapshotSplits.add(lastSplit);
        return snapshotSplits;
    }
}

