/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mongodb.source.assigners.splitters;

import io.debezium.relational.TableId;
import java.util.Collection;
import org.apache.flink.cdc.common.annotation.Experimental;
import org.apache.flink.cdc.connectors.base.source.assigner.splitter.ChunkSplitter;
import org.apache.flink.cdc.connectors.base.source.assigner.state.ChunkSplitterState;
import org.apache.flink.cdc.connectors.base.source.meta.split.SnapshotSplit;
import org.apache.flink.cdc.connectors.mongodb.source.assigners.splitters.ShardedSplitStrategy;
import org.apache.flink.cdc.connectors.mongodb.source.assigners.splitters.SplitContext;
import org.apache.flink.cdc.connectors.mongodb.source.assigners.splitters.SplitVectorSplitStrategy;
import org.apache.flink.cdc.connectors.mongodb.source.config.MongoDBSourceConfig;

@Experimental
public class MongoDBChunkSplitter
implements ChunkSplitter {
    private final MongoDBSourceConfig sourceConfig;

    public MongoDBChunkSplitter(MongoDBSourceConfig sourceConfig) {
        this.sourceConfig = sourceConfig;
    }

    @Override
    public Collection<SnapshotSplit> generateSplits(TableId collectionId) {
        SplitContext splitContext = SplitContext.of(this.sourceConfig, collectionId);
        if (splitContext.isShardedCollection()) {
            return ShardedSplitStrategy.INSTANCE.split(splitContext);
        }
        return SplitVectorSplitStrategy.INSTANCE.split(splitContext);
    }

    @Override
    public void open() {
    }

    @Override
    public boolean hasNextChunk() {
        return false;
    }

    @Override
    public ChunkSplitterState snapshotState(long checkpointId) {
        return ChunkSplitterState.NO_SPLITTING_TABLE_STATE;
    }

    @Override
    public TableId getCurrentSplittingTableId() {
        return null;
    }

    @Override
    public void close() throws Exception {
    }
}

