/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.bulk;

import com.mongodb.assertions.Assertions;
import com.mongodb.bulk.BulkWriteInsert;
import com.mongodb.bulk.BulkWriteUpsert;
import com.mongodb.internal.bulk.WriteRequest;
import java.util.Collections;
import java.util.List;

public abstract class BulkWriteResult {
    public abstract boolean wasAcknowledged();

    public abstract int getInsertedCount();

    public abstract int getMatchedCount();

    public abstract int getDeletedCount();

    public abstract int getModifiedCount();

    public abstract List<BulkWriteInsert> getInserts();

    public abstract List<BulkWriteUpsert> getUpserts();

    @Deprecated
    public static BulkWriteResult acknowledged(WriteRequest.Type type, int count, List<BulkWriteUpsert> upserts) {
        return BulkWriteResult.acknowledged(type, count, (Integer)0, upserts, Collections.emptyList());
    }

    @Deprecated
    public static BulkWriteResult acknowledged(WriteRequest.Type type, int count, Integer modifiedCount, List<BulkWriteUpsert> upserts) {
        return BulkWriteResult.acknowledged(type, count, modifiedCount, upserts, Collections.emptyList());
    }

    public static BulkWriteResult acknowledged(WriteRequest.Type type, int count, Integer modifiedCount, List<BulkWriteUpsert> upserts, List<BulkWriteInsert> inserts) {
        return BulkWriteResult.acknowledged(type == WriteRequest.Type.INSERT ? count : 0, type == WriteRequest.Type.UPDATE || type == WriteRequest.Type.REPLACE ? count : 0, type == WriteRequest.Type.DELETE ? count : 0, modifiedCount, upserts, inserts);
    }

    @Deprecated
    public static BulkWriteResult acknowledged(int insertedCount, int matchedCount, int removedCount, Integer modifiedCount, List<BulkWriteUpsert> upserts) {
        return BulkWriteResult.acknowledged(insertedCount, matchedCount, removedCount, modifiedCount, upserts, Collections.emptyList());
    }

    public static BulkWriteResult acknowledged(final int insertedCount, final int matchedCount, final int removedCount, final Integer modifiedCount, final List<BulkWriteUpsert> upserts, final List<BulkWriteInsert> inserts) {
        return new BulkWriteResult(){

            @Override
            public boolean wasAcknowledged() {
                return true;
            }

            @Override
            public int getInsertedCount() {
                return insertedCount;
            }

            @Override
            public int getMatchedCount() {
                return matchedCount;
            }

            @Override
            public int getDeletedCount() {
                return removedCount;
            }

            @Override
            public int getModifiedCount() {
                return Assertions.assertNotNull(modifiedCount);
            }

            @Override
            public List<BulkWriteInsert> getInserts() {
                return Collections.unmodifiableList(inserts);
            }

            @Override
            public List<BulkWriteUpsert> getUpserts() {
                return Collections.unmodifiableList(upserts);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                BulkWriteResult that = (BulkWriteResult)o;
                if (!that.wasAcknowledged()) {
                    return false;
                }
                if (insertedCount != that.getInsertedCount()) {
                    return false;
                }
                if (!modifiedCount.equals(that.getModifiedCount())) {
                    return false;
                }
                if (removedCount != that.getDeletedCount()) {
                    return false;
                }
                if (matchedCount != that.getMatchedCount()) {
                    return false;
                }
                if (!upserts.equals(that.getUpserts())) {
                    return false;
                }
                return inserts.equals(that.getInserts());
            }

            public int hashCode() {
                int result = upserts.hashCode();
                result = 31 * result + inserts.hashCode();
                result = 31 * result + insertedCount;
                result = 31 * result + matchedCount;
                result = 31 * result + removedCount;
                result = 31 * result + modifiedCount.hashCode();
                return result;
            }

            public String toString() {
                return "AcknowledgedBulkWriteResult{insertedCount=" + insertedCount + ", matchedCount=" + matchedCount + ", removedCount=" + removedCount + ", modifiedCount=" + modifiedCount + ", upserts=" + upserts + ", inserts=" + inserts + '}';
            }
        };
    }

    public static BulkWriteResult unacknowledged() {
        return new BulkWriteResult(){

            @Override
            public boolean wasAcknowledged() {
                return false;
            }

            @Override
            public int getInsertedCount() {
                throw this.getUnacknowledgedWriteException();
            }

            @Override
            public int getMatchedCount() {
                throw this.getUnacknowledgedWriteException();
            }

            @Override
            public int getDeletedCount() {
                throw this.getUnacknowledgedWriteException();
            }

            @Override
            public int getModifiedCount() {
                throw this.getUnacknowledgedWriteException();
            }

            @Override
            public List<BulkWriteInsert> getInserts() {
                throw this.getUnacknowledgedWriteException();
            }

            @Override
            public List<BulkWriteUpsert> getUpserts() {
                throw this.getUnacknowledgedWriteException();
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                BulkWriteResult that = (BulkWriteResult)o;
                return !that.wasAcknowledged();
            }

            public int hashCode() {
                return 0;
            }

            public String toString() {
                return "UnacknowledgedBulkWriteResult{}";
            }

            private UnsupportedOperationException getUnacknowledgedWriteException() {
                return new UnsupportedOperationException("Cannot get information about an unacknowledged write");
            }
        };
    }
}

