/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.util.custom.credentials;

import com.mongodb.kafka.connect.util.custom.credentials.CustomCredentialProvider;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.config.ConfigException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CustomCredentialProviderGenericInitializer {
    static final Logger LOGGER = LoggerFactory.getLogger(CustomCredentialProviderGenericInitializer.class);

    public static CustomCredentialProvider initializeCustomProvider(Map<?, ?> originals) throws ConfigException {
        String customAuthMechanismEnabled = String.valueOf(originals.get("mongo.custom.auth.mechanism.enable"));
        if (customAuthMechanismEnabled == null || customAuthMechanismEnabled.equals("null") || customAuthMechanismEnabled.isEmpty()) {
            throw new ConfigException("mongo.custom.auth.mechanism.enable is not set to true. CustomCredentialProvider should not be used.");
        }
        String qualifiedAuthProviderClassName = String.valueOf(originals.get("mongo.custom.auth.mechanism.providerClass"));
        if (qualifiedAuthProviderClassName == null || qualifiedAuthProviderClassName.equals("null") || qualifiedAuthProviderClassName.isEmpty()) {
            throw new ConfigException("mongo.custom.auth.mechanism.providerClass is required when mongo.custom.auth.mechanism.enable is set to true.");
        }
        try {
            Class<?> authProviderClass = Class.forName(qualifiedAuthProviderClassName, false, CustomCredentialProviderGenericInitializer.class.getClassLoader());
            if (!CustomCredentialProvider.class.isAssignableFrom(authProviderClass)) {
                throw new ConfigException("Provided Class does not implement CustomCredentialProvider interface.");
            }
            CustomCredentialProvider customCredentialProvider = CustomCredentialProviderGenericInitializer.initializeCustomProvider(authProviderClass);
            customCredentialProvider.validate(originals);
            customCredentialProvider.init(originals);
            return customCredentialProvider;
        }
        catch (ClassNotFoundException e) {
            throw new ConfigException("Unable to find " + qualifiedAuthProviderClassName + " on the classpath.");
        }
    }

    private static CustomCredentialProvider initializeCustomProvider(Class<?> authProviderClass) {
        try {
            return (CustomCredentialProvider)authProviderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.error("Error while instantiating " + authProviderClass + " class");
            throw new RuntimeException(e);
        }
    }

    private CustomCredentialProviderGenericInitializer() {
    }
}

