/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.processor;

import com.mongodb.kafka.connect.sink.MongoSinkTopicConfig;
import com.mongodb.kafka.connect.sink.converter.SinkDocument;
import com.mongodb.kafka.connect.sink.processor.PostProcessor;
import com.mongodb.kafka.connect.sink.processor.id.strategy.IdStrategy;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.sink.SinkRecord;
import org.bson.BsonDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentIdAdder
extends PostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentIdAdder.class);
    private final IdStrategy idStrategy;
    private final boolean overwriteExistingIdValues;

    public DocumentIdAdder(MongoSinkTopicConfig config) {
        super(config);
        this.idStrategy = config.getIdStrategy();
        this.overwriteExistingIdValues = config.getBoolean("document.id.strategy.overwrite.existing");
    }

    @Override
    public void process(SinkDocument doc, SinkRecord orig) {
        doc.getValueDoc().ifPresent(vd -> {
            if (this.shouldAppend((BsonDocument)vd)) {
                vd.append("_id", this.idStrategy.generateId(doc, orig));
            } else if (vd.containsKey("_id")) {
                LOGGER.warn("Cannot overwrite the existing '{}' value. '{}' is set to false and the document.", (Object)"_id", (Object)"document.id.strategy.overwrite.existing");
            }
        });
    }

    private boolean shouldAppend(BsonDocument doc) {
        return !doc.containsKey("_id") || this.overwriteExistingIdValues;
    }
}

