/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.processor.field.projection;

import com.mongodb.kafka.connect.sink.MongoSinkTopicConfig;
import com.mongodb.kafka.connect.sink.processor.field.projection.FieldProjector;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonValue;

public abstract class BlockListProjector
extends FieldProjector {
    public BlockListProjector(MongoSinkTopicConfig config, Set<String> fields, FieldProjector.SinkDocumentField sinkDocumentField) {
        super(config, fields, sinkDocumentField);
    }

    @Override
    protected void projectDocument(BsonDocument doc) {
        this.getFields().forEach(f -> this.doProjection((String)f, doc));
    }

    private void doProjection(String field, BsonDocument doc) {
        String otherParts;
        if (!field.contains(".")) {
            this.processNonNestedMatches(field, doc);
            return;
        }
        int dotIdx = field.indexOf(".");
        String firstPart = field.substring(0, dotIdx);
        String string = otherParts = field.length() >= dotIdx ? field.substring(dotIdx + 1) : "";
        if (firstPart.equals("*") || firstPart.equals("**")) {
            this.handleWildcard(firstPart, otherParts, doc);
            return;
        }
        BsonValue value = doc.get(firstPart);
        if (value != null) {
            if (value.isDocument()) {
                this.doProjection(otherParts, value.asDocument());
            }
            if (value.isArray()) {
                BsonArray values = value.asArray();
                for (BsonValue v : values.getValues()) {
                    if (v == null || !v.isDocument()) continue;
                    this.doProjection(otherParts, v.asDocument());
                }
            }
        }
    }

    private void processNonNestedMatches(String field, BsonDocument doc) {
        if (field.equals("*") || field.equals("**")) {
            this.handleWildcard(field, "", doc);
        } else if (field.endsWith("*")) {
            String fieldStartsWith = field.substring(0, field.length() - 1);
            doc.entrySet().removeIf(entry -> ((String)entry.getKey()).startsWith(fieldStartsWith));
        } else {
            doc.remove(field);
        }
    }

    private void handleWildcard(String firstPart, String otherParts, BsonDocument doc) {
        Iterator<Map.Entry<String, BsonValue>> iter = doc.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, BsonValue> entry = iter.next();
            BsonValue value = entry.getValue();
            if (firstPart.equals("**")) {
                iter.remove();
                continue;
            }
            if (!firstPart.equals("*")) continue;
            if (!value.isDocument()) {
                iter.remove();
                continue;
            }
            if (otherParts.isEmpty()) continue;
            this.doProjection(otherParts, (BsonDocument)value);
        }
    }
}

