/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.converter.types.sink.bson;

import com.mongodb.kafka.connect.sink.converter.FieldConverter;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.Schema;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.errors.DataException;
import org.bson.BsonNull;
import org.bson.BsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SinkFieldConverter
extends FieldConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SinkFieldConverter.class);

    public SinkFieldConverter(Schema schema) {
        super(schema);
    }

    public abstract BsonValue toBson(Object var1);

    public BsonValue toBson(Object data, Schema fieldSchema) {
        if (!fieldSchema.isOptional()) {
            if (data == null) {
                throw new DataException("Schema not optional but data was null");
            }
            LOGGER.trace("field not optional and data is '{}'", data);
            return this.toBson(data);
        }
        if (data != null) {
            LOGGER.trace("field optional and data is '{}'", data);
            return this.toBson(data);
        }
        if (fieldSchema.defaultValue() != null) {
            LOGGER.trace("field optional and no data but default value is '{}'", fieldSchema.defaultValue());
            return this.toBson(fieldSchema.defaultValue());
        }
        LOGGER.trace("field optional, no data and no default value thus '{}'", (Object)BsonNull.VALUE);
        return BsonNull.VALUE;
    }
}

