/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mongodb.source.assigners.splitters;

import com.mongodb.client.MongoClient;
import io.debezium.relational.TableId;
import org.apache.flink.cdc.common.annotation.Internal;
import org.apache.flink.cdc.connectors.mongodb.source.config.MongoDBSourceConfig;
import org.apache.flink.cdc.connectors.mongodb.source.utils.MongoUtils;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt64;

@Internal
public class SplitContext {
    private final MongoClient mongoClient;
    private final TableId collectionId;
    private final BsonDocument collectionStats;
    private final int chunkSizeMB;
    private final int samplesPerChunk;

    public SplitContext(MongoClient mongoClient, TableId collectionId, BsonDocument collectionStats, int chunkSizeMB, int samplesPerChunk) {
        this.mongoClient = mongoClient;
        this.collectionId = collectionId;
        this.collectionStats = collectionStats;
        this.chunkSizeMB = chunkSizeMB;
        this.samplesPerChunk = samplesPerChunk;
    }

    public static SplitContext of(MongoDBSourceConfig sourceConfig, TableId collectionId) {
        MongoClient mongoClient = MongoUtils.clientFor(sourceConfig);
        return new SplitContext(mongoClient, collectionId, MongoUtils.collStats(mongoClient, collectionId), sourceConfig.getSplitSize(), sourceConfig.getSamplesPerChunk());
    }

    public MongoClient getMongoClient() {
        return this.mongoClient;
    }

    public TableId getCollectionId() {
        return this.collectionId;
    }

    public int getChunkSizeMB() {
        return this.chunkSizeMB;
    }

    public int getSamplesPerChunk() {
        return this.samplesPerChunk;
    }

    public long getDocumentCount() {
        return this.collectionStats.getNumber("count", new BsonInt64(0L)).longValue();
    }

    public long getSizeInBytes() {
        return this.collectionStats.getNumber("size", new BsonInt64(0L)).longValue();
    }

    public long getAvgObjSizeInBytes() {
        return this.collectionStats.getNumber("avgObjSize", new BsonInt64(0L)).longValue();
    }

    public boolean isShardedCollection() {
        return this.collectionStats.getBoolean("sharded", BsonBoolean.FALSE).getValue();
    }
}

