/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kinesis.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.kinesis.shaded.com.fasterxml.jackson.databind.BeanDescription;
import org.apache.flink.kinesis.shaded.com.fasterxml.jackson.databind.DeserializationConfig;
import org.apache.flink.kinesis.shaded.com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import org.apache.flink.kinesis.shaded.com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import org.apache.flink.kinesis.shaded.com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;

public class BeanDeserializerModifierForIgnorables
extends BeanDeserializerModifier {
    private Class<?> type;
    private List<String> ignorables = new ArrayList<String>();

    public BeanDeserializerModifierForIgnorables(Class clazz, String ... properties) {
        for (String property : properties) {
            this.ignorables.add(property);
        }
        this.type = clazz;
    }

    @Override
    public BeanDeserializerBuilder updateBuilder(DeserializationConfig config, BeanDescription beanDesc, BeanDeserializerBuilder builder) {
        if (!this.type.equals(beanDesc.getBeanClass())) {
            return builder;
        }
        for (String ignorable : this.ignorables) {
            builder.addIgnorable(ignorable);
        }
        return builder;
    }

    @Override
    public List<BeanPropertyDefinition> updateProperties(DeserializationConfig config, BeanDescription beanDesc, List<BeanPropertyDefinition> propDefs) {
        if (!this.type.equals(beanDesc.getBeanClass())) {
            return propDefs;
        }
        ArrayList<BeanPropertyDefinition> newPropDefs = new ArrayList<BeanPropertyDefinition>();
        for (BeanPropertyDefinition propDef : propDefs) {
            if (this.ignorables.contains(propDef.getName())) continue;
            newPropDefs.add(propDef);
        }
        return newPropDefs;
    }
}

