/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kinesis.util;

import java.time.Duration;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.flink.annotation.Internal;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.SdkHttpConfigurationOption;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.LimitExceededException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ProvisionedThroughputExceededException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.AttributeMap;
import org.apache.flink.streaming.connectors.kinesis.config.ConsumerConfigConstants;

@Internal
public class AwsV2Util {
    public static AttributeMap convertProperties(Properties properties) {
        AttributeMap.Builder mapBuilder = AttributeMap.builder();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            if (k.equals("flink.stream.efo.http-client.max-concurrency")) {
                mapBuilder.put(SdkHttpConfigurationOption.MAX_CONNECTIONS, Integer.parseInt(v.toString()));
            }
            if (k.equals("flink.stream.efo.http-client.read-timeout")) {
                mapBuilder.put(SdkHttpConfigurationOption.READ_TIMEOUT, Duration.ofMillis(Long.parseLong(v.toString())));
            }
        }));
        return mapBuilder.build();
    }

    public static boolean isUsingEfoRecordPublisher(Properties properties) {
        return ConsumerConfigConstants.RecordPublisherType.EFO.name().equals(properties.get("flink.stream.recordpublisher"));
    }

    public static boolean isEagerEfoRegistrationType(Properties properties) {
        return ConsumerConfigConstants.EFORegistrationType.EAGER.name().equals(properties.get("flink.stream.efo.registration"));
    }

    public static boolean isLazyEfoRegistrationType(Properties properties) {
        return !AwsV2Util.isEagerEfoRegistrationType(properties) && !AwsV2Util.isNoneEfoRegistrationType(properties);
    }

    public static boolean isNoneEfoRegistrationType(Properties properties) {
        return ConsumerConfigConstants.EFORegistrationType.NONE.name().equals(properties.get("flink.stream.efo.registration"));
    }

    public static boolean isRecoverableException(Exception e) {
        Throwable cause = e.getCause();
        return cause instanceof LimitExceededException || cause instanceof ProvisionedThroughputExceededException;
    }
}

