/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kinesis.proxy;

import java.util.Collections;
import java.util.Properties;
import org.apache.flink.annotation.Internal;
import org.apache.flink.kinesis.shaded.org.apache.flink.connector.aws.util.AWSAsyncSinkUtil;
import org.apache.flink.kinesis.shaded.org.apache.flink.connector.aws.util.AWSGeneralUtil;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.SdkHttpConfigurationOption;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.AttributeMap;
import org.apache.flink.streaming.connectors.kinesis.internals.publisher.fanout.FanOutRecordPublisherConfiguration;
import org.apache.flink.streaming.connectors.kinesis.proxy.FullJitterBackoff;
import org.apache.flink.streaming.connectors.kinesis.proxy.KinesisProxyV2;
import org.apache.flink.streaming.connectors.kinesis.proxy.KinesisProxyV2Interface;
import org.apache.flink.streaming.connectors.kinesis.util.AwsV2Util;
import org.apache.flink.streaming.connectors.kinesis.util.KinesisConfigUtil;
import org.apache.flink.util.Preconditions;

@Internal
public class KinesisProxyV2Factory {
    private static final FullJitterBackoff BACKOFF = new FullJitterBackoff();

    public static KinesisProxyV2Interface createKinesisProxyV2(Properties configProps) {
        Preconditions.checkNotNull((Object)configProps);
        AttributeMap convertedProperties = AwsV2Util.convertProperties(configProps);
        AttributeMap.Builder clientConfiguration = AttributeMap.builder();
        KinesisProxyV2Factory.populateDefaultValues(clientConfiguration);
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient(convertedProperties.merge(clientConfiguration.build()), NettyNioAsyncHttpClient.builder());
        FanOutRecordPublisherConfiguration configuration = new FanOutRecordPublisherConfiguration(configProps, Collections.emptyList());
        Properties asyncClientProperties = KinesisConfigUtil.getV2ConsumerAsyncClientProperties(configProps);
        KinesisAsyncClient client = (KinesisAsyncClient)AWSAsyncSinkUtil.createAwsAsyncClient(asyncClientProperties, httpClient, KinesisAsyncClient.builder(), "Apache Flink %s (%s) Kinesis Connector", "aws.kinesis.client.user-agent-prefix");
        return new KinesisProxyV2(client, httpClient, configuration, BACKOFF);
    }

    private static void populateDefaultValues(AttributeMap.Builder clientConfiguration) {
        clientConfiguration.put(SdkHttpConfigurationOption.TCP_KEEPALIVE, true);
    }
}

