/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kinesis.model;

import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.connectors.kinesis.model.SequenceNumber;

@Internal
public enum SentinelSequenceNumber {
    SENTINEL_LATEST_SEQUENCE_NUM(new SequenceNumber("LATEST_SEQUENCE_NUM")),
    SENTINEL_EARLIEST_SEQUENCE_NUM(new SequenceNumber("EARLIEST_SEQUENCE_NUM")),
    SENTINEL_AT_TIMESTAMP_SEQUENCE_NUM(new SequenceNumber("AT_TIMESTAMP_SEQUENCE_NUM")),
    SENTINEL_SHARD_ENDING_SEQUENCE_NUM(new SequenceNumber("SHARD_ENDING_SEQUENCE_NUM"));

    private SequenceNumber sentinel;

    private SentinelSequenceNumber(SequenceNumber sentinel) {
        this.sentinel = sentinel;
    }

    public SequenceNumber get() {
        return this.sentinel;
    }

    public static boolean isSentinelSequenceNumber(SequenceNumber candidateSequenceNumber) {
        for (SentinelSequenceNumber sentinel : SentinelSequenceNumber.values()) {
            if (!candidateSequenceNumber.equals(sentinel.get())) continue;
            return true;
        }
        return false;
    }
}

