/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.auth;

import java.util.function.Consumer;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.NotThreadSafe;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkPublicApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.ThreadSafe;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.StsClient;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.auth.StsCredentialsProvider;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.model.Credentials;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.model.GetFederationTokenRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.ToString;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.Validate;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
@ThreadSafe
public class StsGetFederationTokenCredentialsProvider
extends StsCredentialsProvider
implements ToCopyableBuilder<Builder, StsGetFederationTokenCredentialsProvider> {
    private final GetFederationTokenRequest getFederationTokenRequest;

    private StsGetFederationTokenCredentialsProvider(Builder builder) {
        super(builder, "sts-get-federation-token-credentials-provider");
        Validate.notNull(builder.getFederationTokenRequest, "Get session token request must not be null.", new Object[0]);
        this.getFederationTokenRequest = builder.getFederationTokenRequest;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected Credentials getUpdatedCredentials(StsClient stsClient) {
        return stsClient.getFederationToken(this.getFederationTokenRequest).credentials();
    }

    public String toString() {
        return ToString.builder("StsGetFederationTokenCredentialsProvider").add("refreshRequest", this.getFederationTokenRequest).build();
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @NotThreadSafe
    public static final class Builder
    extends StsCredentialsProvider.BaseBuilder<Builder, StsGetFederationTokenCredentialsProvider> {
        private GetFederationTokenRequest getFederationTokenRequest;

        private Builder() {
            super((B x$0) -> new StsGetFederationTokenCredentialsProvider((Builder)x$0));
        }

        public Builder(StsGetFederationTokenCredentialsProvider provider) {
            super(x$0 -> new StsGetFederationTokenCredentialsProvider((Builder)x$0), provider);
            this.getFederationTokenRequest = provider.getFederationTokenRequest;
        }

        public Builder refreshRequest(GetFederationTokenRequest getFederationTokenRequest) {
            this.getFederationTokenRequest = getFederationTokenRequest;
            return this;
        }

        public Builder refreshRequest(Consumer<GetFederationTokenRequest.Builder> getFederationTokenRequest) {
            return this.refreshRequest((GetFederationTokenRequest)GetFederationTokenRequest.builder().applyMutation(getFederationTokenRequest).build());
        }

        @Override
        public StsGetFederationTokenCredentialsProvider build() {
            return (StsGetFederationTokenCredentialsProvider)super.build();
        }
    }
}

