/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal.utils;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.kinesis.shaded.io.netty.channel.Channel;
import org.apache.flink.kinesis.shaded.io.netty.channel.ChannelFactory;
import org.apache.flink.kinesis.shaded.io.netty.channel.EventLoopGroup;
import org.apache.flink.kinesis.shaded.io.netty.channel.ReflectiveChannelFactory;
import org.apache.flink.kinesis.shaded.io.netty.channel.epoll.EpollEventLoopGroup;
import org.apache.flink.kinesis.shaded.io.netty.channel.epoll.EpollSocketChannel;
import org.apache.flink.kinesis.shaded.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.flink.kinesis.shaded.io.netty.channel.socket.nio.NioSocketChannel;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal.DelegatingEventLoopGroup;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.FunctionalUtils;

@SdkInternalApi
public final class SocketChannelResolver {
    private static final Map<String, String> KNOWN_EL_GROUPS = new HashMap<String, String>();

    private SocketChannelResolver() {
    }

    public static ChannelFactory<? extends Channel> resolveSocketChannelFactory(EventLoopGroup eventLoopGroup) {
        if (eventLoopGroup instanceof DelegatingEventLoopGroup) {
            return SocketChannelResolver.resolveSocketChannelFactory(((DelegatingEventLoopGroup)eventLoopGroup).getDelegate());
        }
        if (eventLoopGroup instanceof NioEventLoopGroup) {
            return NioSocketChannel::new;
        }
        if (eventLoopGroup instanceof EpollEventLoopGroup) {
            return EpollSocketChannel::new;
        }
        String socketFqcn = KNOWN_EL_GROUPS.get(eventLoopGroup.getClass().getName());
        if (socketFqcn == null) {
            throw new IllegalArgumentException("Unknown event loop group : " + eventLoopGroup.getClass());
        }
        return FunctionalUtils.invokeSafely(() -> new ReflectiveChannelFactory(Class.forName(socketFqcn)));
    }

    static {
        KNOWN_EL_GROUPS.put("org.apache.flink.kinesis.shaded.io.netty.channel.kqueue.KQueueEventLoopGroup", "org.apache.flink.kinesis.shaded.io.netty.channel.kqueue.KQueueSocketChannel");
        KNOWN_EL_GROUPS.put("org.apache.flink.kinesis.shaded.io.netty.channel.oio.OioEventLoopGroup", "org.apache.flink.kinesis.shaded.io.netty.channel.socket.oio.OioSocketChannel");
    }
}

