/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.waiters;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.ThreadSafe;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.exception.SdkClientException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.waiters.WaiterConfiguration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.waiters.WaiterExecutorHelper;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.waiters.WaiterAcceptor;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.waiters.WaiterResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.waiters.WaiterState;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.Either;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.Validate;

@SdkInternalApi
@ThreadSafe
public final class WaiterExecutor<T> {
    private final WaiterExecutorHelper<T> executorHelper;

    public WaiterExecutor(WaiterConfiguration configuration, List<WaiterAcceptor<? super T>> waiterAcceptors) {
        Validate.paramNotNull(configuration, "configuration");
        Validate.paramNotNull(waiterAcceptors, "waiterAcceptors");
        this.executorHelper = new WaiterExecutorHelper<T>(waiterAcceptors, configuration);
    }

    WaiterResponse<T> execute(Supplier<T> pollingFunction) {
        return this.doExecute(pollingFunction, 0, System.currentTimeMillis());
    }

    WaiterResponse<T> doExecute(Supplier<T> pollingFunction, int attemptNumber, long startTime) {
        T response;
        ++attemptNumber;
        try {
            response = pollingFunction.get();
        }
        catch (Exception exception) {
            return this.evaluate(pollingFunction, Either.right(exception), attemptNumber, startTime);
        }
        return this.evaluate(pollingFunction, Either.left(response), attemptNumber, startTime);
    }

    private WaiterResponse<T> evaluate(Supplier<T> pollingFunction, Either<T, Throwable> responseOrException, int attemptNumber, long startTime) {
        Optional<WaiterAcceptor<T>> waiterAcceptor = this.executorHelper.firstWaiterAcceptorIfMatched(responseOrException);
        if (waiterAcceptor.isPresent()) {
            WaiterState state = waiterAcceptor.get().waiterState();
            switch (state) {
                case SUCCESS: {
                    return this.executorHelper.createWaiterResponse(responseOrException, attemptNumber);
                }
                case RETRY: {
                    return this.maybeRetry(pollingFunction, attemptNumber, startTime);
                }
                case FAILURE: {
                    throw this.executorHelper.waiterFailureException(waiterAcceptor.get());
                }
            }
            throw new UnsupportedOperationException();
        }
        throw this.executorHelper.noneMatchException(responseOrException);
    }

    private WaiterResponse<T> maybeRetry(Supplier<T> pollingFunction, int attemptNumber, long startTime) {
        Either<Long, SdkClientException> nextDelayOrUnretryableException = this.executorHelper.nextDelayOrUnretryableException(attemptNumber, startTime);
        if (nextDelayOrUnretryableException.right().isPresent()) {
            throw nextDelayOrUnretryableException.right().get();
        }
        try {
            Thread.sleep(nextDelayOrUnretryableException.left().get());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw SdkClientException.create("The thread got interrupted", e);
        }
        return this.doExecute(pollingFunction, attemptNumber, startTime);
    }
}

