/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.http.pipeline.stages;

import java.time.Duration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.async.AsyncRequestBody;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.http.ExecutionContext;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.InterceptorContext;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.http.HttpClientDependencies;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.http.InterruptMonitor;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.http.RequestExecutionContext;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.http.pipeline.RequestToRequestPipeline;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.util.MetricUtils;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.metrics.CoreMetric;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.signer.AsyncRequestBodySigner;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.signer.Signer;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.SdkHttpFullRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.metrics.MetricCollector;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.Pair;

@SdkInternalApi
public class SigningStage
implements RequestToRequestPipeline {
    private final HttpClientDependencies dependencies;

    public SigningStage(HttpClientDependencies dependencies) {
        this.dependencies = dependencies;
    }

    @Override
    public SdkHttpFullRequest execute(SdkHttpFullRequest request, RequestExecutionContext context) throws Exception {
        InterruptMonitor.checkInterrupted();
        return this.signRequest(request, context);
    }

    private SdkHttpFullRequest signRequest(SdkHttpFullRequest request, RequestExecutionContext context) throws Exception {
        this.updateInterceptorContext(request, context.executionContext());
        Signer signer = context.signer();
        MetricCollector metricCollector = context.attemptMetricCollector();
        if (this.shouldSign(signer)) {
            this.adjustForClockSkew(context.executionAttributes());
            Pair<SdkHttpFullRequest, Duration> measuredSign = MetricUtils.measureDuration(() -> signer.sign(request, context.executionAttributes()));
            metricCollector.reportMetric(CoreMetric.SIGNING_DURATION, measuredSign.right());
            SdkHttpFullRequest signedRequest = measuredSign.left();
            if (signer instanceof AsyncRequestBodySigner) {
                AsyncRequestBody transformedRequestProvider = ((AsyncRequestBodySigner)((Object)signer)).signAsyncRequestBody(signedRequest, context.requestProvider(), context.executionAttributes());
                context.requestProvider(transformedRequestProvider);
            }
            this.updateInterceptorContext(signedRequest, context.executionContext());
            return signedRequest;
        }
        return request;
    }

    private void updateInterceptorContext(SdkHttpFullRequest request, ExecutionContext executionContext) {
        executionContext.interceptorContext((InterceptorContext)executionContext.interceptorContext().copy(b -> b.httpRequest(request)));
    }

    private boolean shouldSign(Signer signer) {
        return signer != null;
    }

    private void adjustForClockSkew(ExecutionAttributes attributes) {
        attributes.putAttribute(SdkExecutionAttribute.TIME_OFFSET, this.dependencies.timeOffset());
    }
}

