/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.http.pipeline.stages;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkClientOption;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.exception.ApiCallTimeoutException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.exception.SdkClientException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.http.HttpClientDependencies;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.http.RequestExecutionContext;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.http.pipeline.RequestPipeline;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.http.timers.TimeoutTracker;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.http.timers.TimerUtils;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.SdkHttpFullRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
public class AsyncApiCallTimeoutTrackingStage<OutputT>
implements RequestPipeline<SdkHttpFullRequest, CompletableFuture<OutputT>> {
    private final RequestPipeline<SdkHttpFullRequest, CompletableFuture<OutputT>> requestPipeline;
    private final SdkClientConfiguration clientConfig;
    private final ScheduledExecutorService scheduledExecutor;

    public AsyncApiCallTimeoutTrackingStage(HttpClientDependencies dependencies, RequestPipeline<SdkHttpFullRequest, CompletableFuture<OutputT>> requestPipeline) {
        this.requestPipeline = requestPipeline;
        this.scheduledExecutor = dependencies.clientConfiguration().option(SdkClientOption.SCHEDULED_EXECUTOR_SERVICE);
        this.clientConfig = dependencies.clientConfiguration();
    }

    @Override
    public CompletableFuture<OutputT> execute(SdkHttpFullRequest input, RequestExecutionContext context) throws Exception {
        CompletableFuture future = new CompletableFuture();
        long apiCallTimeoutInMillis = TimerUtils.resolveTimeoutInMillis(() -> context.requestConfig().apiCallTimeout(), this.clientConfig.option(SdkClientOption.API_CALL_TIMEOUT));
        Supplier<SdkClientException> exceptionSupplier = () -> ApiCallTimeoutException.create(apiCallTimeoutInMillis);
        TimeoutTracker timeoutTracker = TimerUtils.timeAsyncTaskIfNeeded(future, this.scheduledExecutor, exceptionSupplier, apiCallTimeoutInMillis);
        context.apiCallTimeoutTracker(timeoutTracker);
        CompletableFuture<OutputT> executeFuture = this.requestPipeline.execute(input, context);
        executeFuture.whenComplete((r, t) -> {
            if (t != null) {
                future.completeExceptionally((Throwable)t);
            } else {
                future.complete(r);
            }
        });
        return CompletableFutureUtils.forwardExceptionTo(future, executeFuture);
    }
}

