/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.org.apache.flink.connector.aws.util;

import java.net.URI;
import java.util.Optional;
import java.util.Properties;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.kinesis.shaded.org.apache.flink.connector.aws.util.AWSGeneralUtil;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.client.builder.AwsAsyncClientBuilder;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkClient;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.builder.SdkClientBuilder;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkClientOption;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.builder.SdkBuilder;
import org.apache.flink.runtime.util.EnvironmentInformation;

@Internal
public class AWSAsyncSinkUtil
extends AWSGeneralUtil {
    static final String V2_USER_AGENT_SUFFIX = " V2";

    public static String formatFlinkUserAgentPrefix(String userAgentFormat) {
        return String.format(userAgentFormat, EnvironmentInformation.getVersion(), EnvironmentInformation.getRevisionInformation().commitId);
    }

    public static <S extends SdkClient, T extends AwsAsyncClientBuilder<? extends T, S> & AwsClientBuilder<? extends T, S>> S createAwsAsyncClient(Properties configProps, SdkAsyncHttpClient httpClient, T clientBuilder, String awsUserAgentPrefixFormat, String awsClientUserAgentPrefix) {
        SdkClientConfiguration clientConfiguration = SdkClientConfiguration.builder().build();
        return AWSAsyncSinkUtil.createAwsAsyncClient(configProps, clientConfiguration, httpClient, clientBuilder, awsUserAgentPrefixFormat, awsClientUserAgentPrefix);
    }

    public static <S extends SdkClient, T extends AwsAsyncClientBuilder<? extends T, S> & AwsClientBuilder<? extends T, S>> S createAwsAsyncClient(Properties configProps, SdkClientConfiguration clientConfiguration, SdkAsyncHttpClient httpClient, T clientBuilder, String awsUserAgentPrefixFormat, String awsClientUserAgentPrefix) {
        String flinkUserAgentPrefix = Optional.ofNullable(configProps.getProperty(awsClientUserAgentPrefix)).orElse(AWSAsyncSinkUtil.formatFlinkUserAgentPrefix(awsUserAgentPrefixFormat + V2_USER_AGENT_SUFFIX));
        ClientOverrideConfiguration overrideConfiguration = AWSAsyncSinkUtil.createClientOverrideConfiguration(clientConfiguration, ClientOverrideConfiguration.builder(), flinkUserAgentPrefix);
        return AWSAsyncSinkUtil.createAwsAsyncClient(configProps, clientBuilder, httpClient, overrideConfiguration);
    }

    @VisibleForTesting
    static ClientOverrideConfiguration createClientOverrideConfiguration(SdkClientConfiguration config, ClientOverrideConfiguration.Builder overrideConfigurationBuilder, String flinkUserAgentPrefix) {
        overrideConfigurationBuilder.putAdvancedOption(SdkAdvancedClientOption.USER_AGENT_PREFIX, flinkUserAgentPrefix).putAdvancedOption(SdkAdvancedClientOption.USER_AGENT_SUFFIX, config.option(SdkAdvancedClientOption.USER_AGENT_SUFFIX));
        Optional.ofNullable(config.option(SdkClientOption.API_CALL_ATTEMPT_TIMEOUT)).ifPresent(overrideConfigurationBuilder::apiCallAttemptTimeout);
        Optional.ofNullable(config.option(SdkClientOption.API_CALL_TIMEOUT)).ifPresent(overrideConfigurationBuilder::apiCallTimeout);
        return (ClientOverrideConfiguration)overrideConfigurationBuilder.build();
    }

    @VisibleForTesting
    static <S extends SdkClient, T extends AwsAsyncClientBuilder<? extends T, S> & AwsClientBuilder<? extends T, S>> S createAwsAsyncClient(Properties configProps, T clientBuilder, SdkAsyncHttpClient httpClient, ClientOverrideConfiguration overrideConfiguration) {
        if (configProps.containsKey("aws.endpoint")) {
            URI endpointOverride = URI.create(configProps.getProperty("aws.endpoint"));
            ((SdkClientBuilder)clientBuilder).endpointOverride(endpointOverride);
        }
        return (S)((SdkClient)((SdkBuilder)((Object)((AwsAsyncClientBuilder)((AwsClientBuilder)((Object)((AwsAsyncClientBuilder)((AwsClientBuilder)((Object)((AwsAsyncClientBuilder)((SdkClientBuilder)((Object)((AwsAsyncClientBuilder)clientBuilder.httpClient(httpClient)))).overrideConfiguration(overrideConfiguration)))).credentialsProvider(AWSAsyncSinkUtil.getCredentialsProvider(configProps))))).region(AWSAsyncSinkUtil.getRegion(configProps))))).build());
    }
}

