/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.s3.model.transform;

import org.apache.flink.kinesis.shaded.com.amazonaws.services.s3.internal.XmlWriter;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.s3.model.replication.ReplicationAndOperator;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.s3.model.replication.ReplicationFilterPredicate;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.s3.model.replication.ReplicationPredicateVisitor;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.s3.model.replication.ReplicationPrefixPredicate;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.s3.model.replication.ReplicationTagPredicate;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.s3.model.transform.BucketConfigurationXmlFactoryFunctions;

class ReplicationPredicateVisitorImpl
implements ReplicationPredicateVisitor {
    private final XmlWriter xml;

    public ReplicationPredicateVisitorImpl(XmlWriter xml) {
        this.xml = xml;
    }

    @Override
    public void visit(ReplicationPrefixPredicate replicationPrefixPredicate) {
        BucketConfigurationXmlFactoryFunctions.writePrefix(this.xml, replicationPrefixPredicate.getPrefix());
    }

    @Override
    public void visit(ReplicationTagPredicate replicationTagPredicate) {
        BucketConfigurationXmlFactoryFunctions.writeTag(this.xml, replicationTagPredicate.getTag());
    }

    @Override
    public void visit(ReplicationAndOperator replicationAndOperator) {
        this.xml.start("And");
        for (ReplicationFilterPredicate predicate : replicationAndOperator.getOperands()) {
            predicate.accept(this);
        }
        this.xml.end();
    }
}

