/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.metrics.impl;

import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.Dimension;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.MetricDatum;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.StatisticSet;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.metrics.impl.AccumulateByNameMetricsScope;
import org.apache.flink.kinesis.shaded.org.apache.commons.logging.Log;
import org.apache.flink.kinesis.shaded.org.apache.commons.logging.LogFactory;

public class LogMetricsScope
extends AccumulateByNameMetricsScope {
    private static final Log LOG = LogFactory.getLog(LogMetricsScope.class);

    @Override
    public void end() {
        StringBuilder output = new StringBuilder();
        output.append("Metrics:\n");
        output.append("Dimensions: ");
        boolean needsComma = false;
        for (Dimension dimension : this.getDimensions()) {
            output.append(String.format("%s[%s: %s]", needsComma ? ", " : "", dimension.getName(), dimension.getValue()));
            needsComma = true;
        }
        output.append("\n");
        for (MetricDatum datum : this.data.values()) {
            StatisticSet statistics = datum.getStatisticValues();
            output.append(String.format("Name=%25s\tMin=%.2f\tMax=%.2f\tCount=%.2f\tSum=%.2f\tAvg=%.2f\tUnit=%s\n", datum.getMetricName(), statistics.getMinimum(), statistics.getMaximum(), statistics.getSampleCount(), statistics.getSum(), statistics.getSum() / statistics.getSampleCount(), datum.getUnit()));
        }
        LOG.info(output.toString());
    }
}

