/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.config;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.config.IPropertyValueDecoder;

class DatePropertyValueDecoder
implements IPropertyValueDecoder<Date> {
    DatePropertyValueDecoder() {
    }

    @Override
    public Date decodeValue(String value) {
        try {
            return new Date(Long.parseLong(value) * 1000L);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Date property value must be numeric.");
        }
    }

    @Override
    public List<Class<Date>> getSupportedTypes() {
        return Arrays.asList(Date.class);
    }
}

