/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.transform;

import java.util.List;
import org.apache.flink.kinesis.shaded.com.amazonaws.SdkClientException;
import org.apache.flink.kinesis.shaded.com.amazonaws.annotation.SdkInternalApi;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.MarshallLocation;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.MarshallingInfo;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.MarshallingType;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.GlobalTable;

@SdkInternalApi
public class GlobalTableMarshaller {
    private static final MarshallingInfo<String> GLOBALTABLENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GlobalTableName").build();
    private static final MarshallingInfo<List> REPLICATIONGROUP_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationGroup").build();
    private static final GlobalTableMarshaller instance = new GlobalTableMarshaller();

    public static GlobalTableMarshaller getInstance() {
        return instance;
    }

    public void marshall(GlobalTable globalTable, ProtocolMarshaller protocolMarshaller) {
        if (globalTable == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(globalTable.getGlobalTableName(), GLOBALTABLENAME_BINDING);
            protocolMarshaller.marshall(globalTable.getReplicationGroup(), REPLICATIONGROUP_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

