/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.flink.kinesis.shaded.com.amazonaws.annotation.SdkInternalApi;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperFieldModel;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverter;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.StandardAnnotationMaps;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.StandardBeanProperties;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.StandardTypeConverters;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.ScalarAttributeType;

@SdkInternalApi
final class ConvertibleType<T> {
    private final DynamoDBTypeConverter<?, T> typeConverter;
    private final DynamoDBMapperFieldModel.DynamoDBAttributeType attributeType;
    private final ConvertibleType<T>[] params;
    private final Class<T> targetType;
    @Deprecated
    private final Method getter;
    @Deprecated
    private final Method setter;

    private ConvertibleType(Type genericType, StandardAnnotationMaps.TypedMap<T> annotations, Method getter) {
        this.typeConverter = annotations.typeConverter();
        this.attributeType = annotations.attributeType();
        if (this.typeConverter != null) {
            ConvertibleType<T> target = ConvertibleType.of(this.typeConverter);
            this.targetType = target.targetType;
            this.params = target.params;
        } else if (genericType instanceof ParameterizedType) {
            Type[] paramTypes = ((ParameterizedType)genericType).getActualTypeArguments();
            this.targetType = annotations.targetType();
            this.params = new ConvertibleType[paramTypes.length];
            for (int i = 0; i < paramTypes.length; ++i) {
                this.params[i] = ConvertibleType.of(paramTypes[i]);
            }
        } else {
            this.targetType = annotations.targetType();
            this.params = new ConvertibleType[0];
        }
        this.setter = getter == null ? null : StandardBeanProperties.MethodReflect.setterOf(getter);
        this.getter = getter;
    }

    final <S> DynamoDBTypeConverter<S, T> typeConverter() {
        return this.typeConverter;
    }

    final DynamoDBMapperFieldModel.DynamoDBAttributeType attributeType() {
        return this.attributeType;
    }

    @Deprecated
    final Method getter() {
        return this.getter;
    }

    @Deprecated
    final Method setter() {
        return this.setter;
    }

    final <t> ConvertibleType<t> param(int index) {
        return this.params.length > index ? this.params[index] : null;
    }

    final boolean is(ScalarAttributeType scalarAttributeType, StandardTypeConverters.Vector vector) {
        return this.param(0) != null && this.param(0).is(scalarAttributeType) && this.is(vector);
    }

    final boolean is(ScalarAttributeType scalarAttributeType) {
        return StandardTypeConverters.Scalar.of(this.targetType()).is(scalarAttributeType);
    }

    final boolean is(StandardTypeConverters.Scalar scalar) {
        return scalar.is(this.targetType());
    }

    final boolean is(StandardTypeConverters.Vector vector) {
        return vector.is(this.targetType());
    }

    final boolean is(Class<?> type) {
        return type.isAssignableFrom(this.targetType());
    }

    final Class<T> targetType() {
        return this.targetType;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.targetType().getSimpleName());
        if (this.params.length > 0) {
            builder.append("<");
            for (int i = 0; i < this.params.length; ++i) {
                builder.append(i == 0 ? "" : ",").append(this.params[i]);
            }
            builder.append(">");
        }
        return builder.toString();
    }

    static <T> ConvertibleType<T> of(Method getter, StandardAnnotationMaps.TypedMap<T> annotations) {
        return new ConvertibleType<T>(getter.getGenericReturnType(), annotations, getter);
    }

    private static <T> ConvertibleType<T> of(DynamoDBTypeConverter<?, T> converter) {
        Class<?> clazz = converter.getClass();
        if (!clazz.isInterface()) {
            for (Class<?> c = clazz; Object.class != c; c = c.getSuperclass()) {
                for (Type genericType : c.getGenericInterfaces()) {
                    ConvertibleType<T> type = ConvertibleType.of(genericType);
                    if (!type.is(DynamoDBTypeConverter.class) || type.params.length != 2 || type.param(0).targetType() == Object.class) continue;
                    return type.param(0);
                }
            }
            ConvertibleType<T> type = ConvertibleType.of(clazz.getGenericSuperclass());
            if (type.is(DynamoDBTypeConverter.class) && type.params.length > 0 && type.param(0).targetType() != Object.class) {
                return type.param(0);
            }
        }
        throw new DynamoDBMappingException("could not resolve type of " + clazz);
    }

    private static <T> ConvertibleType<T> of(Type genericType) {
        Class targetType = genericType instanceof Class ? (Class<byte[]>)((Object)genericType) : (genericType instanceof ParameterizedType ? (Class)((ParameterizedType)genericType).getRawType() : (genericType.toString().equals("byte[]") ? byte[].class : Object.class));
        StandardAnnotationMaps.TableMap annotations = StandardAnnotationMaps.of(targetType);
        return new ConvertibleType(genericType, annotations, null);
    }
}

