/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBDeleteExpression;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapper;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperConfig;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperTableModel;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBQueryExpression;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBSaveExpression;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBScanExpression;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.IDynamoDBMapper;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.KeyPair;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.PaginatedParallelScanList;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.PaginatedQueryList;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.PaginatedScanList;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.QueryResultPage;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.S3ClientCache;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.S3Link;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.ScanResultPage;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.TransactionLoadRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.TransactionWriteRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.AttributeValue;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.DeleteTableRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.s3.model.Region;

public class AbstractDynamoDBMapper
implements IDynamoDBMapper {
    private final DynamoDBMapperConfig config;

    protected AbstractDynamoDBMapper(DynamoDBMapperConfig defaults) {
        this.config = DynamoDBMapperConfig.DEFAULT.merge(defaults);
    }

    protected AbstractDynamoDBMapper() {
        this(DynamoDBMapperConfig.DEFAULT);
    }

    protected final String getTableName(Class<?> clazz, Object object, DynamoDBMapperConfig config) {
        if (config.getObjectTableNameResolver() != null && object != null) {
            return config.getObjectTableNameResolver().getTableName(object, config);
        }
        return this.getTableName(clazz, config);
    }

    protected final String getTableName(Class<?> clazz, DynamoDBMapperConfig config) {
        if (config.getTableNameResolver() == null) {
            return DynamoDBMapperConfig.DefaultTableNameResolver.INSTANCE.getTableName(clazz, config);
        }
        return config.getTableNameResolver().getTableName(clazz, config);
    }

    protected final DynamoDBMapperConfig mergeConfig(DynamoDBMapperConfig overrides) {
        return this.config.merge(overrides);
    }

    @Override
    public <T> DynamoDBMapperTableModel<T> getTableModel(Class<T> clazz) {
        return this.getTableModel(clazz, this.config);
    }

    @Override
    public <T> DynamoDBMapperTableModel<T> getTableModel(Class<T> clazz, DynamoDBMapperConfig config) {
        throw new UnsupportedOperationException("operation not supported in " + this.getClass());
    }

    @Override
    public <T> T load(Class<T> clazz, Object hashKey, DynamoDBMapperConfig config) {
        return this.load(clazz, hashKey, null, config);
    }

    @Override
    public <T> T load(Class<T> clazz, Object hashKey) {
        return this.load(clazz, hashKey, null, this.config);
    }

    @Override
    public <T> T load(Class<T> clazz, Object hashKey, Object rangeKey) {
        return this.load(clazz, hashKey, rangeKey, this.config);
    }

    @Override
    public <T> T load(Class<T> clazz, Object hashKey, Object rangeKey, DynamoDBMapperConfig config) {
        throw new UnsupportedOperationException("operation not supported in " + this.getClass());
    }

    @Override
    public <T> T load(T keyObject) {
        return this.load(keyObject, this.config);
    }

    @Override
    public <T> T load(T keyObject, DynamoDBMapperConfig config) {
        throw new UnsupportedOperationException("operation not supported in " + this.getClass());
    }

    @Override
    public <T> T marshallIntoObject(Class<T> clazz, Map<String, AttributeValue> itemAttributes) {
        return this.marshallIntoObject(clazz, itemAttributes, this.config);
    }

    public <T> T marshallIntoObject(Class<T> clazz, Map<String, AttributeValue> itemAttributes, DynamoDBMapperConfig config) {
        throw new UnsupportedOperationException("operation not supported in " + this.getClass());
    }

    @Override
    public <T> List<T> marshallIntoObjects(Class<T> clazz, List<Map<String, AttributeValue>> itemAttributes) {
        return this.marshallIntoObjects(clazz, itemAttributes, this.config);
    }

    public <T> List<T> marshallIntoObjects(Class<T> clazz, List<Map<String, AttributeValue>> itemAttributes, DynamoDBMapperConfig config) {
        throw new UnsupportedOperationException("operation not supported in " + this.getClass());
    }

    @Override
    public <T> void save(T object) {
        this.save(object, null, this.config);
    }

    @Override
    public <T> void save(T object, DynamoDBSaveExpression saveExpression) {
        this.save(object, saveExpression, this.config);
    }

    @Override
    public <T> void save(T object, DynamoDBMapperConfig config) {
        this.save(object, null, config);
    }

    @Override
    public <T> void save(T object, DynamoDBSaveExpression saveExpression, DynamoDBMapperConfig config) {
        throw new UnsupportedOperationException("operation not supported in " + this.getClass());
    }

    @Override
    public void delete(Object object) {
        this.delete(object, null, this.config);
    }

    @Override
    public void delete(Object object, DynamoDBDeleteExpression deleteExpression) {
        this.delete(object, deleteExpression, this.config);
    }

    @Override
    public void delete(Object object, DynamoDBMapperConfig config) {
        this.delete(object, null, config);
    }

    @Override
    public <T> void delete(T object, DynamoDBDeleteExpression deleteExpression, DynamoDBMapperConfig config) {
        throw new UnsupportedOperationException("operation not supported in " + this.getClass());
    }

    @Override
    public void transactionWrite(TransactionWriteRequest transactionWriteRequest) {
        this.transactionWrite(transactionWriteRequest, null);
    }

    @Override
    public void transactionWrite(TransactionWriteRequest transactionWriteRequest, DynamoDBMapperConfig config) {
        throw new UnsupportedOperationException("operation not supported in " + this.getClass());
    }

    @Override
    public List<Object> transactionLoad(TransactionLoadRequest transactionLoadRequest) {
        return this.transactionLoad(transactionLoadRequest, null);
    }

    @Override
    public List<Object> transactionLoad(TransactionLoadRequest transactionLoadRequest, DynamoDBMapperConfig config) {
        throw new UnsupportedOperationException("operation not supported in " + this.getClass());
    }

    @Override
    public List<DynamoDBMapper.FailedBatch> batchDelete(Iterable<? extends Object> objectsToDelete) {
        return this.batchWrite(Collections.emptyList(), objectsToDelete, this.config);
    }

    @Override
    public List<DynamoDBMapper.FailedBatch> batchDelete(Object ... objectsToDelete) {
        return this.batchWrite(Collections.emptyList(), Arrays.asList(objectsToDelete), this.config);
    }

    @Override
    public List<DynamoDBMapper.FailedBatch> batchSave(Iterable<? extends Object> objectsToSave) {
        return this.batchWrite(objectsToSave, Collections.emptyList(), this.config);
    }

    @Override
    public List<DynamoDBMapper.FailedBatch> batchSave(Object ... objectsToSave) {
        return this.batchWrite(Arrays.asList(objectsToSave), Collections.emptyList(), this.config);
    }

    @Override
    public List<DynamoDBMapper.FailedBatch> batchWrite(Iterable<? extends Object> objectsToWrite, Iterable<? extends Object> objectsToDelete) {
        return this.batchWrite(objectsToWrite, objectsToDelete, this.config);
    }

    @Override
    public List<DynamoDBMapper.FailedBatch> batchWrite(Iterable<? extends Object> objectsToWrite, Iterable<? extends Object> objectsToDelete, DynamoDBMapperConfig config) {
        throw new UnsupportedOperationException("operation not supported in " + this.getClass());
    }

    @Override
    public Map<String, List<Object>> batchLoad(Iterable<? extends Object> itemsToGet) {
        return this.batchLoad(itemsToGet, this.config);
    }

    @Override
    public Map<String, List<Object>> batchLoad(Iterable<? extends Object> itemsToGet, DynamoDBMapperConfig config) {
        throw new UnsupportedOperationException("operation not supported in " + this.getClass());
    }

    @Override
    public Map<String, List<Object>> batchLoad(Map<Class<?>, List<KeyPair>> itemsToGet) {
        return this.batchLoad(itemsToGet, this.config);
    }

    @Override
    public Map<String, List<Object>> batchLoad(Map<Class<?>, List<KeyPair>> itemsToGet, DynamoDBMapperConfig config) {
        throw new UnsupportedOperationException("operation not supported in " + this.getClass());
    }

    @Override
    public <T> PaginatedScanList<T> scan(Class<T> clazz, DynamoDBScanExpression scanExpression) {
        return this.scan(clazz, scanExpression, this.config);
    }

    @Override
    public <T> PaginatedScanList<T> scan(Class<T> clazz, DynamoDBScanExpression scanExpression, DynamoDBMapperConfig config) {
        throw new UnsupportedOperationException("operation not supported in " + this.getClass());
    }

    @Override
    public <T> PaginatedParallelScanList<T> parallelScan(Class<T> clazz, DynamoDBScanExpression scanExpression, int totalSegments) {
        return this.parallelScan(clazz, scanExpression, totalSegments, this.config);
    }

    @Override
    public <T> PaginatedParallelScanList<T> parallelScan(Class<T> clazz, DynamoDBScanExpression scanExpression, int totalSegments, DynamoDBMapperConfig config) {
        throw new UnsupportedOperationException("operation not supported in " + this.getClass());
    }

    @Override
    public <T> ScanResultPage<T> scanPage(Class<T> clazz, DynamoDBScanExpression scanExpression) {
        return this.scanPage(clazz, scanExpression, this.config);
    }

    @Override
    public <T> ScanResultPage<T> scanPage(Class<T> clazz, DynamoDBScanExpression scanExpression, DynamoDBMapperConfig config) {
        throw new UnsupportedOperationException("operation not supported in " + this.getClass());
    }

    @Override
    public int count(Class<?> clazz, DynamoDBScanExpression scanExpression) {
        return this.count(clazz, scanExpression, this.config);
    }

    @Override
    public int count(Class<?> clazz, DynamoDBScanExpression scanExpression, DynamoDBMapperConfig config) {
        throw new UnsupportedOperationException("operation not supported in " + this.getClass());
    }

    @Override
    public <T> PaginatedQueryList<T> query(Class<T> clazz, DynamoDBQueryExpression<T> queryExpression) {
        return this.query(clazz, queryExpression, this.config);
    }

    @Override
    public <T> PaginatedQueryList<T> query(Class<T> clazz, DynamoDBQueryExpression<T> queryExpression, DynamoDBMapperConfig config) {
        throw new UnsupportedOperationException("operation not supported in " + this.getClass());
    }

    @Override
    public <T> QueryResultPage<T> queryPage(Class<T> clazz, DynamoDBQueryExpression<T> queryExpression) {
        return this.queryPage(clazz, queryExpression, this.config);
    }

    @Override
    public <T> QueryResultPage<T> queryPage(Class<T> clazz, DynamoDBQueryExpression<T> queryExpression, DynamoDBMapperConfig config) {
        throw new UnsupportedOperationException("operation not supported in " + this.getClass());
    }

    @Override
    public <T> int count(Class<T> clazz, DynamoDBQueryExpression<T> queryExpression) {
        return this.count(clazz, queryExpression, this.config);
    }

    @Override
    public <T> int count(Class<T> clazz, DynamoDBQueryExpression<T> queryExpression, DynamoDBMapperConfig config) {
        throw new UnsupportedOperationException("operation not supported in " + this.getClass());
    }

    @Override
    public S3ClientCache getS3ClientCache() {
        throw new UnsupportedOperationException("operation not supported in " + this.getClass());
    }

    @Override
    public S3Link createS3Link(String bucketName, String key) {
        return this.createS3Link((Region)null, bucketName, key);
    }

    @Override
    public S3Link createS3Link(Region s3region, String bucketName, String key) {
        throw new UnsupportedOperationException("operation not supported in " + this.getClass());
    }

    @Override
    public S3Link createS3Link(String s3region, String bucketName, String key) {
        throw new UnsupportedOperationException("operation not supported in " + this.getClass());
    }

    @Override
    public CreateTableRequest generateCreateTableRequest(Class<?> clazz) {
        return this.generateCreateTableRequest(clazz, this.config);
    }

    public <T> CreateTableRequest generateCreateTableRequest(Class<T> clazz, DynamoDBMapperConfig config) {
        throw new UnsupportedOperationException("operation not supported in " + this.getClass());
    }

    @Override
    public DeleteTableRequest generateDeleteTableRequest(Class<?> clazz) {
        return this.generateDeleteTableRequest(clazz, this.config);
    }

    public <T> DeleteTableRequest generateDeleteTableRequest(Class<T> clazz, DynamoDBMapperConfig config) {
        throw new UnsupportedOperationException("operation not supported in " + this.getClass());
    }
}

