/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.transform;

import javax.xml.stream.events.XMLEvent;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.LabelOptions;
import org.apache.flink.kinesis.shaded.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import org.apache.flink.kinesis.shaded.com.amazonaws.transform.StaxUnmarshallerContext;
import org.apache.flink.kinesis.shaded.com.amazonaws.transform.Unmarshaller;

public class LabelOptionsStaxUnmarshaller
implements Unmarshaller<LabelOptions, StaxUnmarshallerContext> {
    private static LabelOptionsStaxUnmarshaller instance;

    @Override
    public LabelOptions unmarshall(StaxUnmarshallerContext context) throws Exception {
        LabelOptions labelOptions = new LabelOptions();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return labelOptions;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (!context.testExpression("Timezone", targetDepth)) continue;
                labelOptions.setTimezone(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return labelOptions;
    }

    public static LabelOptionsStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new LabelOptionsStaxUnmarshaller();
        }
        return instance;
    }
}

