/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.transform;

import org.apache.flink.kinesis.shaded.com.amazonaws.DefaultRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.Request;
import org.apache.flink.kinesis.shaded.com.amazonaws.SdkClientException;
import org.apache.flink.kinesis.shaded.com.amazonaws.http.HttpMethodName;
import org.apache.flink.kinesis.shaded.com.amazonaws.internal.SdkInternalList;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.Dimension;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.GetMetricStatisticsRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.transform.Marshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.util.StringUtils;

public class GetMetricStatisticsRequestMarshaller
implements Marshaller<Request<GetMetricStatisticsRequest>, GetMetricStatisticsRequest> {
    @Override
    public Request<GetMetricStatisticsRequest> marshall(GetMetricStatisticsRequest getMetricStatisticsRequest) {
        if (getMetricStatisticsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetMetricStatisticsRequest> request = new DefaultRequest<GetMetricStatisticsRequest>(getMetricStatisticsRequest, "AmazonCloudWatch");
        request.addParameter("Action", "GetMetricStatistics");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (getMetricStatisticsRequest.getNamespace() != null) {
            request.addParameter("Namespace", StringUtils.fromString(getMetricStatisticsRequest.getNamespace()));
        }
        if (getMetricStatisticsRequest.getMetricName() != null) {
            request.addParameter("MetricName", StringUtils.fromString(getMetricStatisticsRequest.getMetricName()));
        }
        if (!getMetricStatisticsRequest.getDimensions().isEmpty() || !((SdkInternalList)getMetricStatisticsRequest.getDimensions()).isAutoConstruct()) {
            SdkInternalList dimensionsList = (SdkInternalList)getMetricStatisticsRequest.getDimensions();
            int dimensionsListIndex = 1;
            for (Dimension dimensionsListValue : dimensionsList) {
                if (dimensionsListValue != null) {
                    if (dimensionsListValue.getName() != null) {
                        request.addParameter("Dimensions.member." + dimensionsListIndex + ".Name", StringUtils.fromString(dimensionsListValue.getName()));
                    }
                    if (dimensionsListValue.getValue() != null) {
                        request.addParameter("Dimensions.member." + dimensionsListIndex + ".Value", StringUtils.fromString(dimensionsListValue.getValue()));
                    }
                }
                ++dimensionsListIndex;
            }
        }
        if (getMetricStatisticsRequest.getStartTime() != null) {
            request.addParameter("StartTime", StringUtils.fromDate(getMetricStatisticsRequest.getStartTime()));
        }
        if (getMetricStatisticsRequest.getEndTime() != null) {
            request.addParameter("EndTime", StringUtils.fromDate(getMetricStatisticsRequest.getEndTime()));
        }
        if (getMetricStatisticsRequest.getPeriod() != null) {
            request.addParameter("Period", StringUtils.fromInteger(getMetricStatisticsRequest.getPeriod()));
        }
        if (!getMetricStatisticsRequest.getStatistics().isEmpty() || !((SdkInternalList)getMetricStatisticsRequest.getStatistics()).isAutoConstruct()) {
            SdkInternalList statisticsList = (SdkInternalList)getMetricStatisticsRequest.getStatistics();
            int statisticsListIndex = 1;
            for (String statisticsListValue : statisticsList) {
                if (statisticsListValue != null) {
                    request.addParameter("Statistics.member." + statisticsListIndex, StringUtils.fromString(statisticsListValue));
                }
                ++statisticsListIndex;
            }
        }
        if (!getMetricStatisticsRequest.getExtendedStatistics().isEmpty() || !((SdkInternalList)getMetricStatisticsRequest.getExtendedStatistics()).isAutoConstruct()) {
            SdkInternalList extendedStatisticsList = (SdkInternalList)getMetricStatisticsRequest.getExtendedStatistics();
            int extendedStatisticsListIndex = 1;
            for (String extendedStatisticsListValue : extendedStatisticsList) {
                if (extendedStatisticsListValue != null) {
                    request.addParameter("ExtendedStatistics.member." + extendedStatisticsListIndex, StringUtils.fromString(extendedStatisticsListValue));
                }
                ++extendedStatisticsListIndex;
            }
        }
        if (getMetricStatisticsRequest.getUnit() != null) {
            request.addParameter("Unit", StringUtils.fromString(getMetricStatisticsRequest.getUnit()));
        }
        return request;
    }
}

