/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.message.DeleteGroupsRequestData;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.message.DeleteGroupsResponseData;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.AbstractRequest;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.AbstractResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.DeleteGroupsResponse;

public class DeleteGroupsRequest
extends AbstractRequest {
    private final DeleteGroupsRequestData data;

    public DeleteGroupsRequest(DeleteGroupsRequestData data, short version) {
        super(ApiKeys.DELETE_GROUPS, version);
        this.data = data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        Errors error = Errors.forException(e);
        DeleteGroupsResponseData.DeletableGroupResultCollection groupResults = new DeleteGroupsResponseData.DeletableGroupResultCollection();
        for (String groupId : this.data.groupsNames()) {
            groupResults.add(new DeleteGroupsResponseData.DeletableGroupResult().setGroupId(groupId).setErrorCode(error.code()));
        }
        return new DeleteGroupsResponse(new DeleteGroupsResponseData().setResults(groupResults).setThrottleTimeMs(throttleTimeMs));
    }

    public static DeleteGroupsRequest parse(ByteBuffer buffer, short version) {
        return new DeleteGroupsRequest(new DeleteGroupsRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    @Override
    public DeleteGroupsRequestData data() {
        return this.data;
    }

    public static class Builder
    extends AbstractRequest.Builder<DeleteGroupsRequest> {
        private final DeleteGroupsRequestData data;

        public Builder(DeleteGroupsRequestData data) {
            super(ApiKeys.DELETE_GROUPS);
            this.data = data;
        }

        @Override
        public DeleteGroupsRequest build(short version) {
            return new DeleteGroupsRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

