/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.message.BrokerRegistrationRequestData;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.message.BrokerRegistrationResponseData;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.AbstractRequest;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.BrokerRegistrationResponse;

public class BrokerRegistrationRequest
extends AbstractRequest {
    private final BrokerRegistrationRequestData data;

    public BrokerRegistrationRequest(BrokerRegistrationRequestData data, short version) {
        super(ApiKeys.BROKER_REGISTRATION, version);
        this.data = data;
    }

    @Override
    public BrokerRegistrationRequestData data() {
        return this.data;
    }

    @Override
    public BrokerRegistrationResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        Errors error = Errors.forException(e);
        return new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(error.code()));
    }

    public static BrokerRegistrationRequest parse(ByteBuffer buffer, short version) {
        return new BrokerRegistrationRequest(new BrokerRegistrationRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<BrokerRegistrationRequest> {
        private final BrokerRegistrationRequestData data;

        public Builder(BrokerRegistrationRequestData data) {
            super(ApiKeys.BROKER_REGISTRATION);
            this.data = data;
        }

        @Override
        public BrokerRegistrationRequest build(short version) {
            return new BrokerRegistrationRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

